/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.collection;

import ch.lambdaj.Lambda;
import ch.lambdaj.collection.LambdaCollection;
import ch.lambdaj.collection.LambdaSet;
import ch.lambdaj.function.convert.Converter;
import ch.lambdaj.util.IntrospectionUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambdaMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private Map<K, V> innerMap;

    LambdaMap(Map<? extends K, ? extends V> innerMap) {
        this.innerMap = innerMap;
    }

    public <T> LambdaMap<K, T> convertValues(Converter<V, T> converter) {
        return new LambdaMap<K, Converter<V, T>>(Lambda.convertMap(this.innerMap, converter));
    }

    public <T> LambdaMap<K, T> convertValues(T argument) {
        return new LambdaMap<K, T>(Lambda.convertMap(this.innerMap, argument));
    }

    public LambdaMap<K, V> retainKeys(Matcher<?> matcher) {
        return this.retain(matcher, true);
    }

    public LambdaMap<K, V> removeKeys(Matcher<?> matcher) {
        return this.retainKeys(Matchers.not(matcher));
    }

    public LambdaMap<K, V> retainValues(Matcher<?> matcher) {
        return this.retain(matcher, false);
    }

    public LambdaMap<K, V> removeValues(Matcher<?> matcher) {
        return this.retainValues(Matchers.not(matcher));
    }

    private LambdaMap<K, V> retain(Matcher<?> matcher, boolean matchKeys) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : this.innerMap.entrySet()) {
            if (!matcher.matches(matchKeys ? entry.getKey() : entry.getValue())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        try {
            this.innerMap.clear();
            this.innerMap.putAll(map);
        }
        catch (UnsupportedOperationException e) {
            this.innerMap = map;
        }
        return this;
    }

    @Override
    public void clear() {
        this.innerMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.innerMap.containsValue(value);
    }

    @Override
    public LambdaSet<Map.Entry<K, V>> entrySet() {
        return new LambdaSet<Map.Entry<K, V>>(this.innerMap.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return this.innerMap.equals(o);
    }

    @Override
    public V get(Object key) {
        return this.innerMap.get(key);
    }

    @Override
    public int hashCode() {
        return this.innerMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.innerMap.isEmpty();
    }

    @Override
    public LambdaSet<K> keySet() {
        return new LambdaSet<K>(this.innerMap.keySet());
    }

    @Override
    public V put(K key, V value) {
        return this.innerMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.innerMap.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.innerMap.remove(key);
    }

    @Override
    public int size() {
        return this.innerMap.size();
    }

    @Override
    public LambdaCollection<V> values() {
        return new LambdaCollection<V>(this.innerMap.values());
    }

    public LambdaMap<K, V> clone() {
        return this.clone(new HashMap());
    }

    public LambdaMap<K, V> clone(Map<K, V> emptyMap) {
        try {
            return new LambdaMap<K, V>((Map)IntrospectionUtil.clone(this.innerMap));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            emptyMap.putAll(this.innerMap);
            return new LambdaMap<K, V>(emptyMap);
        }
    }

    public String toString() {
        return this.innerMap.toString();
    }
}

