/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.argument;

import ch.lambdaj.function.argument.Invocation;
import ch.lambdaj.function.argument.Invoker;
import ch.lambdaj.function.argument.InvokerJitter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InvocationSequence
implements Invoker {
    private static boolean jittingEnabled = false;
    private static ExecutorService executor;
    private final Class<?> rootInvokedClass;
    private String inkvokedPropertyName;
    Invocation lastInvocation;
    private int hashCode;
    private boolean jitDone;
    private AtomicBoolean needsJitting;
    private Invoker invoker = this;

    static void enableJitting(boolean enable) {
        if (enable) {
            jittingEnabled = true;
            if (executor == null) {
                executor = Executors.newCachedThreadPool(new ThreadFactory(){

                    public Thread newThread(Runnable r) {
                        Thread t = new Thread(r);
                        t.setDaemon(true);
                        return t;
                    }
                });
            }
        } else {
            jittingEnabled = false;
            if (executor != null) {
                executor.shutdown();
                executor = null;
            }
        }
    }

    InvocationSequence(Class<?> rootInvokedClass) {
        this.rootInvokedClass = rootInvokedClass;
        this.jitDone = true;
    }

    InvocationSequence(InvocationSequence sequence, Invocation invocation) {
        boolean isJittable;
        this.rootInvokedClass = sequence.getRootInvokedClass();
        invocation.previousInvocation = sequence.lastInvocation;
        this.lastInvocation = invocation;
        boolean bl = isJittable = jittingEnabled && this.isJittable(this.lastInvocation);
        if (isJittable) {
            this.needsJitting = new AtomicBoolean(isJittable);
        }
        this.jitDone = !isJittable;
    }

    Class<?> getRootInvokedClass() {
        return this.rootInvokedClass;
    }

    String getInkvokedPropertyName() {
        if (this.inkvokedPropertyName == null) {
            this.inkvokedPropertyName = this.calcInkvokedPropertyName();
        }
        return this.inkvokedPropertyName;
    }

    private String calcInkvokedPropertyName() {
        if (null == this.lastInvocation) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.calcInkvokedPropertyName(this.lastInvocation, this.lastInvocation.previousInvocation, sb);
        return sb.substring(1);
    }

    private void calcInkvokedPropertyName(Invocation inv, Invocation prevInv, StringBuilder sb) {
        if (prevInv != null) {
            this.calcInkvokedPropertyName(prevInv, prevInv.previousInvocation, sb);
        }
        sb.append(".").append(inv.getInvokedPropertyName());
    }

    Class<?> getReturnType() {
        return this.lastInvocation.getReturnType();
    }

    public boolean equals(Object object) {
        return object != null && this.rootInvokedClass == ((InvocationSequence)object).rootInvokedClass && Invocation.areNullSafeEquals(this.lastInvocation, ((InvocationSequence)object).lastInvocation);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = 13 * this.rootInvokedClass.hashCode();
        int factor = 17;
        Invocation invocation = this.lastInvocation;
        while (invocation != null) {
            this.hashCode += factor * invocation.hashCode();
            factor += 2;
            invocation = invocation.previousInvocation;
        }
        return this.hashCode;
    }

    public Object evaluate(final Object object) {
        if (!this.jitDone && this.needsJitting.compareAndSet(true, false)) {
            this.jitDone = true;
            if (executor != null) {
                executor.submit(new Runnable(){

                    public void run() {
                        InvocationSequence.this.invoker = new InvokerJitter(object, InvocationSequence.this).jitInvoker();
                    }
                });
            }
        }
        return this.invoker.invokeOn(object);
    }

    @Override
    public Object invokeOn(Object object) {
        return this.invokeOn(this.lastInvocation, object);
    }

    private Object invokeOn(Invocation invocation, Object value) {
        if (invocation == null) {
            return value;
        }
        if (invocation.previousInvocation != null) {
            value = this.invokeOn(invocation.previousInvocation, value);
        }
        return invocation.invokeOn(value);
    }

    private boolean isJittable(Invocation invocation) {
        return !invocation.hasArguments() && (invocation.previousInvocation == null || this.isJittable(invocation.previousInvocation));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("[");
        if (this.lastInvocation == null) {
            sb.append(this.rootInvokedClass);
        } else {
            this.toString(this.lastInvocation, this.lastInvocation.previousInvocation, sb, true);
        }
        sb.append("]");
        return sb.toString();
    }

    private void toString(Invocation inv, Invocation prevInv, StringBuilder sb, boolean first) {
        if (prevInv != null) {
            this.toString(prevInv, prevInv.previousInvocation, sb, false);
        }
        sb.append(inv);
        if (!first) {
            sb.append(", ");
        }
    }
}

