/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.argument;

import ch.lambdaj.function.argument.Invocation;
import ch.lambdaj.function.argument.InvocationSequence;
import ch.lambdaj.function.argument.Invoker;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.cglib.asm.ClassWriter;
import net.sf.cglib.asm.Label;
import net.sf.cglib.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvokerJitter {
    private static final AtomicInteger jitCounter = new AtomicInteger(1);
    private final InternalClassLoader classLoader;
    private final InvocationSequence invocationSequence;

    InvokerJitter(Object invokedObject, InvocationSequence invocationSequence) {
        this(invokedObject.getClass().getClassLoader(), invocationSequence);
    }

    InvokerJitter(ClassLoader classLoader, InvocationSequence invocationSequence) {
        this.classLoader = new InternalClassLoader(classLoader);
        this.invocationSequence = invocationSequence;
    }

    Invoker jitInvoker() {
        try {
            int id = jitCounter.getAndIncrement();
            Class<?> clazz = this.classLoader.defineClass("ch.lambdaj.function.argument.Invoker_" + id, this.generateBytecode(id));
            return (Invoker)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] generateBytecode(int id) {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(49, 33, "ch/lambdaj/function/argument/Invoker_" + id, null, "java/lang/Object", new String[]{"ch/lambdaj/function/argument/Invoker"});
        this.jitEmptyConstructor(cw);
        this.jitInvocationMethod(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void jitEmptyConstructor(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void jitInvocationMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "invokeOn", "(Ljava/lang/Object;)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        this.jitInvocationSequence(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void jitInvocationSequence(MethodVisitor mv) {
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.getClassName(this.invocationSequence.getRootInvokedClass()));
        this.jitInvocation(mv, this.invocationSequence.lastInvocation);
    }

    private void jitInvocation(MethodVisitor mv, Invocation invocation) {
        if (invocation.previousInvocation != null) {
            this.jitInvocation(mv, invocation.previousInvocation);
        }
        mv.visitVarInsn(58, 2);
        Label nonNull = new Label();
        mv.visitVarInsn(25, 2);
        mv.visitJumpInsn(199, nonNull);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitLabel(nonNull);
        mv.visitVarInsn(25, 2);
        Method method = invocation.getInvokedMethod();
        if (method.getDeclaringClass().isInterface()) {
            mv.visitMethodInsn(185, this.getClassName(method.getDeclaringClass()), method.getName(), "()" + this.getInternalName(method.getReturnType()));
        } else {
            mv.visitMethodInsn(182, this.getClassName(method.getDeclaringClass()), method.getName(), "()" + this.getInternalName(method.getReturnType()));
        }
        this.primitiveToObject(mv, method.getReturnType());
    }

    private String getClassName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    private String getInternalName(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return "L" + this.getClassName(clazz) + ";";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        return "B";
    }

    private void primitiveToObject(MethodVisitor mv, Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return;
        }
        if (clazz == Integer.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (clazz == Long.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (clazz == Double.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (clazz == Float.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (clazz == Boolean.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (clazz == Character.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (clazz == Short.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (clazz == Byte.TYPE) {
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalClassLoader
    extends ClassLoader {
        InternalClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        Class<?> defineClass(String name, byte[] b) {
            return this.defineClass(name, b, 0, b.length);
        }
    }
}

