/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.closure;

import ch.lambdaj.function.argument.Argument;
import ch.lambdaj.function.argument.ArgumentsFactory;
import ch.lambdaj.function.closure.AbstractClosure;
import ch.lambdaj.function.closure.Closure;
import ch.lambdaj.function.closure.Closure1;
import ch.lambdaj.function.closure.Closure2;
import ch.lambdaj.function.closure.Closure3;
import ch.lambdaj.function.closure.Closure4;
import ch.lambdaj.function.closure.ProxyClosure;
import ch.lambdaj.proxy.ProxyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClosuresFactory {
    private static final ThreadLocal<AbstractClosure> CLOSURES = new ThreadLocal();

    private ClosuresFactory() {
    }

    public static <T> T bindClosure(Object closed, Class<T> closedClass) {
        return CLOSURES.get().of(closed, closedClass);
    }

    static <T> T createProxyClosure(AbstractClosure closure, Class<T> closedClass) {
        return ProxyUtil.createProxy(new ProxyClosure(closure), closedClass, true, new Class[0]);
    }

    public static Closure createClosure() {
        Closure closure = new Closure();
        CLOSURES.set(closure);
        return closure;
    }

    public static <A> Closure1<A> createClosure(Class<A> type1) {
        Closure1 closure = new Closure1();
        CLOSURES.set(closure);
        return closure;
    }

    public static <A, B> Closure2<A, B> createClosure(Class<A> type1, Class<B> type2) {
        Closure2 closure = new Closure2();
        CLOSURES.set(closure);
        return closure;
    }

    public static <A, B, C> Closure3<A, B, C> createClosure(Class<A> type1, Class<B> type2, Class<C> type3) {
        Closure3 closure = new Closure3();
        CLOSURES.set(closure);
        return closure;
    }

    public static <A, B, C, D> Closure4<A, B, C, D> createClosure(Class<A> type1, Class<B> type2, Class<C> type3, Class<D> type4) {
        Closure4 closure = new Closure4();
        CLOSURES.set(closure);
        return closure;
    }

    public static <T> T createClosureVarPlaceholder(Class<T> clazz) {
        return ArgumentsFactory.createClosureArgumentPlaceholder(clazz);
    }

    static ClosureVarType getClosureVarType(Object object) {
        if (object == null) {
            return ClosureVarType.FIXED;
        }
        if (ClosuresFactory.getClosureVarArgument(object) != null) {
            return ClosureVarType.VAR;
        }
        if (ArgumentsFactory.createClosureArgumentPlaceholder(object.getClass()).equals(object)) {
            return ClosureVarType.FINAL_VAR;
        }
        return ClosureVarType.FIXED;
    }

    static <T> Argument<T> getClosureVarArgument(T placeholder) {
        return ArgumentsFactory.placeholderToClosureArgument(placeholder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ClosureVarType {
        VAR,
        FINAL_VAR,
        FIXED;


        boolean isClosureVarPlaceholder() {
            return this == VAR || this == FINAL_VAR;
        }
    }
}

