/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.closure;

import ch.lambdaj.function.closure.AbstractClosure;
import ch.lambdaj.function.closure.ClosuresFactory;
import ch.lambdaj.function.closure.DelayedClosure;
import ch.lambdaj.proxy.InvocationInterceptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ProxyClosure
extends InvocationInterceptor {
    private boolean registered = false;
    private final AbstractClosure closure;

    ProxyClosure(AbstractClosure closure) {
        this.closure = closure;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (this.registered) {
            return method.invoke(proxy, args);
        }
        this.registered = true;
        this.closure.bindInvocation(method, args);
        DelayedClosure.call();
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            this.closure.closeUnhandledInvocations();
            return null;
        }
        return ClosuresFactory.createProxyClosure(this.closure, returnType);
    }
}

