/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.compare;

import ch.lambdaj.function.argument.Argument;
import ch.lambdaj.function.argument.ArgumentsFactory;
import ch.lambdaj.function.compare.ComparatorUtil;
import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentComparator<T, A>
implements Comparator<T>,
Serializable {
    private final Argument<A> argument;
    private final Comparator<Object> comparator;

    public ArgumentComparator(A argument) {
        this(ArgumentsFactory.actualArgument(argument));
    }

    public ArgumentComparator(Argument<A> argument) {
        this.argument = argument;
        this.comparator = ComparatorUtil.DEFAULT_ARGUMENT_COMPARATOR;
    }

    public ArgumentComparator(A argument, Comparator<A> comparator) {
        this(ArgumentsFactory.actualArgument(argument), comparator);
    }

    public ArgumentComparator(Argument<A> argument, Comparator<A> comparator) {
        this.argument = argument;
        this.comparator = comparator;
    }

    @Override
    public int compare(T o1, T o2) {
        return ComparatorUtil.nullSafeCompare(this.comparator, this.argument.evaluate(o1), this.argument.evaluate(o2));
    }
}

