/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.compare;

import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComparatorUtil {
    static final Comparator<Object> DEFAULT_ARGUMENT_COMPARATOR = new DefaultArgumentComparator();
    static final Comparator<Object> DESCENDING_ARGUMENT_COMPARATOR = new DescendingArgumentComparator();
    static final Comparator<Object> IGNORE_CASE_ARGUMENT_COMPARATOR = new IgnoreCaseArgumentComparator();
    static final Comparator<Object> DESCENDING_IGNORE_CASE_ARGUMENT_COMPARATOR = new DescendingIgnoreCaseArgumentComparator();

    private ComparatorUtil() {
    }

    public static int nullSafeCompare(Object o1, Object o2) {
        return ComparatorUtil.nullSafeCompare(DEFAULT_ARGUMENT_COMPARATOR, o1, o2);
    }

    static int nullSafeCompare(Comparator<Object> comparator, Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null ? 0 : 1;
        }
        return o2 == null ? -1 : comparator.compare(o1, o2);
    }

    public static Comparator<Object> getStandardComparator(int option) {
        switch (option) {
            case 0: {
                return DEFAULT_ARGUMENT_COMPARATOR;
            }
            case 1: {
                return DESCENDING_ARGUMENT_COMPARATOR;
            }
            case 2: {
                return IGNORE_CASE_ARGUMENT_COMPARATOR;
            }
            case 3: {
                return DESCENDING_IGNORE_CASE_ARGUMENT_COMPARATOR;
            }
        }
        throw new RuntimeException("Unknown comparator option: " + option);
    }

    static class DescendingIgnoreCaseArgumentComparator
    extends IgnoreCaseArgumentComparator {
        DescendingIgnoreCaseArgumentComparator() {
        }

        public int compare(Object val1, Object val2) {
            return -super.compare(val1, val2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IgnoreCaseArgumentComparator
    implements Comparator<Object>,
    Serializable {
        IgnoreCaseArgumentComparator() {
        }

        @Override
        public int compare(Object val1, Object val2) {
            if (val1 == null) {
                return val2 == null ? 0 : 1;
            }
            return val2 == null ? -1 : ((String)val1).compareToIgnoreCase((String)val2);
        }
    }

    static class DescendingArgumentComparator
    extends DefaultArgumentComparator {
        DescendingArgumentComparator() {
        }

        public int compare(Object val1, Object val2) {
            int asc = super.compare(val1, val2);
            return -asc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultArgumentComparator
    implements Comparator<Object>,
    Serializable {
        DefaultArgumentComparator() {
        }

        @Override
        public int compare(Object val1, Object val2) {
            if (val1 == null) {
                return val2 == null ? 0 : 1;
            }
            return val2 == null ? -1 : ((Comparable)val1).compareTo(val2);
        }
    }
}

