/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.convert;

import ch.lambdaj.function.argument.Argument;
import ch.lambdaj.function.argument.ArgumentsFactory;
import ch.lambdaj.function.convert.Converter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasedArgumentConverter<F, T>
implements Converter<F, Map.Entry<String, T>> {
    private final String alias;
    private final Argument<T> argument;

    public AliasedArgumentConverter(T argument) {
        this.argument = ArgumentsFactory.actualArgument(argument);
        this.alias = this.argument.getInkvokedPropertyName();
    }

    public AliasedArgumentConverter(String alias, T argument) {
        this.argument = ArgumentsFactory.actualArgument(argument);
        this.alias = alias;
    }

    @Override
    public Map.Entry<String, T> convert(final F from) {
        return new Map.Entry<String, T>(){

            @Override
            public String getKey() {
                return AliasedArgumentConverter.this.alias;
            }

            @Override
            public T getValue() {
                return AliasedArgumentConverter.this.argument.evaluate(from);
            }

            @Override
            public T setValue(T value) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

