/*
 * Decompiled with CFR 0.152.
 */
package ch.lambdaj.function.convert;

import ch.lambdaj.function.convert.ArgumentConverter;
import ch.lambdaj.function.convert.Converter;
import ch.lambdaj.util.IntrospectionException;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorArgumentConverter<F, T>
implements Converter<F, T> {
    private Constructor<T> constructor;
    private final List<ArgumentConverter<F, Object>> argumentConverters = new LinkedList<ArgumentConverter<F, Object>>();

    public ConstructorArgumentConverter(Class<T> clazz, Object ... arguments) {
        for (Constructor<?> c : clazz.getConstructors()) {
            if (!this.isCompatible(c, arguments)) continue;
            this.constructor = c;
            break;
        }
        if (this.constructor == null) {
            throw new IntrospectionException("Unable to find a constructor of " + clazz.getName() + " compatible with the given arguments");
        }
        if (arguments != null) {
            for (Object argument : arguments) {
                this.argumentConverters.add(new ArgumentConverter(argument));
            }
        }
    }

    private boolean isCompatible(Constructor<?> constructor, Object ... arguments) {
        try {
            constructor.newInstance(arguments);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public T convert(F from) {
        Object[] initArgs = new Object[this.argumentConverters.size()];
        int i = 0;
        for (ArgumentConverter<F, Object> argumentConverter : this.argumentConverters) {
            initArgs[i++] = argumentConverter.convert(from);
        }
        try {
            return this.constructor.newInstance(initArgs);
        }
        catch (Exception e) {
            throw new IntrospectionException("Unable to create an object of class " + this.constructor.getDeclaringClass().getName(), e);
        }
    }
}

