/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.CategoryModel;
import org.zkoss.zul.ChartModel;
import org.zkoss.zul.Flash;
import org.zkoss.zul.PieModel;
import org.zkoss.zul.event.ChartDataEvent;
import org.zkoss.zul.event.ChartDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flashchart
extends Flash {
    private static final long serialVersionUID = 20091126115842L;
    private String _type = "pie";
    private String _chartStyle;
    private ChartModel _model;
    private ChartDataListener _dataListener;
    private LinkedList<JSONObject> _seriesList;
    private String _yAxis = "Series 1";
    private String _xAxis = "Series 2";
    private static final List _VALID_TYPES = Arrays.asList("pie", "line", "bar", "column", "stackbar", "stackcolumn");

    public Flashchart() {
        this.setWidth("400px");
        this.setHeight("200px");
    }

    private void refresh() {
        this.smartUpdate("refresh", Flashchart.getJSONResponse(this.transferToJSONObject(this.getModel())));
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "type", this._type.split(":")[0]);
        if (this._chartStyle != null) {
            this.render(renderer, "chartStyle", this._chartStyle);
        }
        this.render(renderer, "jsonModel", Flashchart.getJSONResponse(this.transferToJSONObject(this.getModel())));
        if (!this._type.equals("pie")) {
            this.render(renderer, "jsonSeries", Flashchart.getJSONResponse(this._seriesList));
        }
    }

    public void setType(String type) {
        if (!Flashchart.isValid(type)) {
            throw new UiException("Type must be one of the following: pie, line, bar, column, stackbar, stackcolumn");
        }
        if (!Objects.equals((Object)this._type, (Object)type)) {
            this._type = type;
            this.invalidate();
        }
    }

    public String getType() {
        return this._type;
    }

    public void setModel(ChartModel model) {
        if (this._model != model) {
            if (this._model != null) {
                this._model.removeChartDataListener(this._dataListener);
            }
            this._model = model;
            if (this._dataListener == null) {
                this._dataListener = new DefaultChartDataListener();
                this._model.addChartDataListener(this._dataListener);
            }
            this.invalidate();
        }
    }

    public ChartModel getModel() {
        return this._model;
    }

    public void setXaxis(String xAxis) {
        if (xAxis != null) {
            this._xAxis = xAxis;
            this.invalidate();
        }
    }

    public String getXaxis() {
        return this._xAxis;
    }

    public void setYaxis(String yAxis) {
        if (yAxis != null) {
            this._yAxis = yAxis;
            this.invalidate();
        }
    }

    public String getYaxis() {
        return this._yAxis;
    }

    public void setChartStyle(String chartStyle) {
        if (!Objects.equals((Object)this._chartStyle, (Object)chartStyle)) {
            this._chartStyle = chartStyle;
            this.invalidate();
        }
    }

    public String getChartStyle() {
        return this._chartStyle;
    }

    private List<JSONObject> transferToJSONObject(ChartModel model) {
        LinkedList<JSONObject> list = new LinkedList<JSONObject>();
        if (model == null || this._type == null) {
            return list;
        }
        if ("pie".equals(this._type)) {
            PieModel tempModel = (PieModel)model;
            for (int i = 0; i < tempModel.getCategories().size(); ++i) {
                Comparable category = tempModel.getCategory(i);
                JSONObject json = new JSONObject();
                json.put((Object)"categoryField", (Object)category);
                json.put((Object)"dataField", (Object)tempModel.getValue(category));
                list.add(json);
            }
        } else {
            int i;
            this._seriesList = new LinkedList();
            CategoryModel tempModel = (CategoryModel)model;
            int seriesLength = tempModel.getSeries().size();
            String fieldKey = Flashchart.isHorizontal(this._type) ? "xField" : "yField";
            for (i = 0; i < seriesLength; ++i) {
                Comparable series = tempModel.getSeries(i);
                JSONObject json = new JSONObject();
                json.put((Object)fieldKey, (Object)Flashchart.escape(series));
                json.put((Object)"displayName", (Object)series);
                this._seriesList.add(json);
            }
            for (i = 0; i < tempModel.getCategories().size(); ++i) {
                Comparable category = tempModel.getCategory(i);
                JSONObject jData = new JSONObject();
                jData.put((Object)"values", (Object)category);
                for (int j = 0; j < seriesLength; ++j) {
                    Comparable series = tempModel.getSeries(j);
                    jData.put((Object)Flashchart.escape(series), (Object)tempModel.getValue(series, category));
                }
                list.add(jData);
            }
        }
        return list;
    }

    private static String escape(Object series) {
        return "'" + series + "'";
    }

    private static boolean isHorizontal(String type) {
        return "bar".equals(type) || "stackbar".equals(type);
    }

    private static boolean isValid(String type) {
        return _VALID_TYPES.contains(type);
    }

    private static String getJSONResponse(List list) {
        if (list == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer().append('[');
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String s = String.valueOf(it.next());
            sb.append(s).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        return sb.toString().replaceAll("\\\\", "");
    }

    private class DefaultChartDataListener
    implements ChartDataListener,
    Serializable {
        private static final long serialVersionUID = 20091125153002L;

        private DefaultChartDataListener() {
        }

        public void onChange(ChartDataEvent event) {
            Flashchart.this.refresh();
        }
    }
}

