/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoxHandleKit;
import org.jhotdraw.draw.ChopBoxConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Options;
import org.jhotdraw.draw.SetBoundsEdit;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Insets2DDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFigure
implements Figure {
    protected EventListenerList listenerList = new EventListenerList();
    private boolean isConnectorsVisible;
    private ConnectionFigure courtingConnection;
    private Drawing drawing;
    private boolean isInteractive;
    private boolean isVisible = true;
    protected Figure decorator;
    private boolean isDrawDecoratorFirst = false;
    protected int changingDepth = 0;

    @Override
    public void addFigureListener(FigureListener figureListener) {
        this.listenerList.add(FigureListener.class, figureListener);
    }

    @Override
    public void removeFigureListener(FigureListener figureListener) {
        this.listenerList.remove(FigureListener.class, figureListener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(UndoableEditListener.class, undoableEditListener);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(UndoableEditListener.class, undoableEditListener);
    }

    @Override
    public void addNotify(Drawing drawing) {
        this.drawing = drawing;
        this.fireFigureAdded();
    }

    @Override
    public void removeNotify(Drawing drawing) {
        this.fireFigureRemoved();
        this.drawing = null;
    }

    protected Drawing getDrawing() {
        return this.drawing;
    }

    protected Object getLock() {
        return this.getDrawing() == null ? this : this.getDrawing().getLock();
    }

    public void setDrawDecoratorFirst(boolean bl) {
        this.isDrawDecoratorFirst = bl;
    }

    public boolean isDrawDecoratorFirst() {
        return this.isDrawDecoratorFirst;
    }

    public void fireAreaInvalidated() {
        this.fireAreaInvalidated(this.getDrawBounds());
    }

    protected void fireAreaInvalidated(Rectangle2D.Double double_) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, double_);
                }
                ((FigureListener)objectArray[i + 1]).figureAreaInvalidated(figureEvent);
            }
        }
    }

    protected void fireFigureRequestRemove() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)objectArray[i + 1]).figureRequestRemove(figureEvent);
            }
        }
    }

    protected void fireFigureAdded() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)objectArray[i + 1]).figureAdded(figureEvent);
            }
        }
    }

    protected void fireFigureRemoved() {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, this.getBounds());
                }
                ((FigureListener)objectArray[i + 1]).figureRemoved(figureEvent);
            }
        }
    }

    public void fireFigureChanged() {
        this.fireFigureChanged(this.getBounds());
    }

    protected void fireFigureChanged(Rectangle2D.Double double_) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, double_);
                }
                ((FigureListener)objectArray[i + 1]).figureChanged(figureEvent);
            }
        }
    }

    protected void fireFigureChanged(FigureEvent figureEvent) {
        if (this.listenerList.getListenerCount() > 0) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                ((FigureListener)objectArray[i + 1]).figureChanged(figureEvent);
            }
        }
    }

    protected void fireAttributeChanged(AttributeKey attributeKey, Object object, Object object2) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureEvent figureEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != FigureListener.class) continue;
                if (figureEvent == null) {
                    figureEvent = new FigureEvent(this, attributeKey, object, object2);
                }
                ((FigureListener)objectArray[i + 1]).figureAttributeChanged(figureEvent);
            }
        }
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        UndoableEditEvent undoableEditEvent = null;
        if (this.listenerList.getListenerCount() > 0) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (undoableEditEvent == null) {
                    undoableEditEvent = new UndoableEditEvent(this, undoableEdit);
                }
                if (objectArray[i] != UndoableEditListener.class) continue;
                ((UndoableEditListener)objectArray[i + 1]).undoableEditHappened(undoableEditEvent);
            }
        }
    }

    @Override
    public AbstractFigure clone() {
        try {
            AbstractFigure abstractFigure = (AbstractFigure)super.clone();
            abstractFigure.listenerList = new EventListenerList();
            abstractFigure.isConnectorsVisible = false;
            abstractFigure.courtingConnection = null;
            if (this.decorator != null) {
                abstractFigure.decorator = (Figure)this.decorator.clone();
            }
            return abstractFigure;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError(cloneNotSupportedException.getMessage());
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
    }

    public final AbstractFigure basicClone(HashMap<Figure, Figure> hashMap) {
        return null;
    }

    public void remap(HashMap<Figure, Figure> hashMap) {
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        if (n == 0) {
            BoxHandleKit.addBoxHandles(this, linkedList);
        }
        return linkedList;
    }

    @Override
    public Cursor getCursor(Point2D.Double double_) {
        if (this.contains(double_)) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getDefaultCursor();
    }

    public final void setBounds(Rectangle2D.Double double_) {
        this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
    }

    public void setBounds(Point2D.Double double_, Point2D.Double double_2) {
        Point2D.Double double_3 = this.getStartPoint();
        Point2D.Double double_4 = this.getEndPoint();
        if (!double_3.equals(double_) || !double_4.equals(double_2)) {
            this.willChange();
            this.basicSetBounds(double_, double_2);
            this.changed();
            this.fireUndoableEditHappened(new SetBoundsEdit(this, double_3, double_4, double_, double_2));
        }
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public void invalidate() {
        this.fireAreaInvalidated(this.getDrawBounds());
    }

    protected boolean isChanging() {
        return this.changingDepth != 0;
    }

    protected int getChangingDepth() {
        return this.changingDepth;
    }

    @Override
    public void willChange() {
        ++this.changingDepth;
        this.invalidate();
    }

    protected void validate() {
    }

    @Override
    public void changed() {
        if (this.changingDepth <= 1) {
            this.validate();
            this.fireFigureChanged(this.getDrawBounds());
            this.changingDepth = 0;
        } else {
            --this.changingDepth;
        }
    }

    public void transform(AffineTransform affineTransform) {
        this.willChange();
        this.basicTransform(affineTransform);
        this.fireUndoableEditHappened(new TransformEdit(this, affineTransform));
        this.changed();
    }

    @Override
    public abstract void basicTransform(AffineTransform var1);

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return new ChopBoxConnector(this);
    }

    @Override
    public boolean includes(Figure figure) {
        return figure == this;
    }

    @Override
    public Figure findFigureInside(Point2D.Double double_) {
        return this.contains(double_) ? this : null;
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return new ChopBoxConnector(this);
    }

    @Override
    public Collection<Action> getActions(Point2D.Double double_) {
        return Collections.emptyList();
    }

    @Override
    public Tool getTool(Point2D.Double double_) {
        return null;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double double_, MouseEvent mouseEvent, DrawingView drawingView) {
        return false;
    }

    @Override
    public boolean handleDrop(Point2D.Double double_, Collection<Figure> collection, DrawingView drawingView) {
        return false;
    }

    @Override
    public Point2D.Double getEndPoint() {
        Rectangle2D.Double double_ = this.getBounds();
        return new Point2D.Double(double_.x + double_.width, double_.y + double_.height);
    }

    @Override
    public Point2D.Double getStartPoint() {
        Rectangle2D.Double double_ = this.getBounds();
        return new Point2D.Double(double_.x, double_.y);
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double double_ = this.getBounds();
        return new Dimension2DDouble(double_.width, double_.height);
    }

    public void remap(Map map) {
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void setInteractive(boolean bl) {
        this.isInteractive = bl;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl != this.isVisible) {
            this.willChange();
            this.isVisible = bl;
            this.changed();
        }
    }

    @Override
    public void setConnectorsVisible(boolean bl, ConnectionFigure connectionFigure) {
        this.willChange();
        this.isConnectorsVisible = bl;
        this.courtingConnection = connectionFigure;
        this.changed();
    }

    @Override
    public boolean isConnectorsVisible() {
        return this.isConnectorsVisible;
    }

    protected ConnectionFigure getCourtingConnection() {
        return this.courtingConnection;
    }

    @Override
    public Collection<Figure> getDecomposition() {
        LinkedList<Figure> linkedList = new LinkedList<Figure>();
        linkedList.add(this);
        return linkedList;
    }

    protected FontRenderContext getFontRenderContext() {
        FontRenderContext fontRenderContext = null;
        if (fontRenderContext == null) {
            fontRenderContext = new FontRenderContext(new AffineTransform(), Options.isTextAntialiased(), Options.isFractionalMetrics());
        }
        return fontRenderContext;
    }

    @Override
    public void requestRemove() {
        this.fireFigureRequestRemove();
    }

    @Override
    public int getLayer() {
        return 0;
    }

    @Override
    public String getTooltip(Point2D.Double double_) {
        return null;
    }

    @Override
    public void setDecorator(Figure figure) {
        this.willChange();
        this.decorator = figure;
        if (this.decorator != null) {
            this.decorator.basicSetBounds(this.getStartPoint(), this.getEndPoint());
        }
        this.changed();
    }

    @Override
    public Figure getDecorator() {
        return this.decorator;
    }

    @Override
    public final void draw(Graphics2D graphics2D) {
        if (this.isDrawDecoratorFirst()) {
            this.drawDecorator(graphics2D);
            this.drawFigure(graphics2D);
        } else {
            this.drawFigure(graphics2D);
            this.drawDecorator(graphics2D);
        }
    }

    protected abstract void drawFigure(Graphics2D var1);

    protected void drawDecorator(Graphics2D graphics2D) {
        if (this.decorator != null) {
            this.updateDecoratorBounds();
            this.decorator.draw(graphics2D);
        }
    }

    protected void updateDecoratorBounds() {
        if (this.decorator != null) {
            Point2D.Double double_ = this.getStartPoint();
            Point2D.Double double_2 = this.getEndPoint();
            Insets2DDouble insets2DDouble = AttributeKeys.DECORATOR_INSETS.get(this);
            double_.x -= insets2DDouble.left;
            double_.y -= insets2DDouble.top;
            double_2.x += insets2DDouble.right;
            double_2.y += insets2DDouble.bottom;
            this.decorator.basicSetBounds(double_, double_2);
        }
    }

    @Override
    public final Rectangle2D.Double getDrawBounds() {
        Rectangle2D.Double double_ = this.getFigureDrawBounds();
        if (this.decorator != null) {
            this.updateDecoratorBounds();
            double_.add(this.decorator.getDrawBounds());
        }
        return double_;
    }

    protected abstract Rectangle2D.Double getFigureDrawBounds();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
        stringBuilder.append('@');
        stringBuilder.append(this.hashCode());
        return stringBuilder.toString();
    }
}

