/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Map;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Bezier;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.undo.CompositeEdit;

public class BezierTool
extends AbstractTool {
    private Boolean finishWhenMouseReleased;
    protected Map<AttributeKey, Object> attributes;
    private BezierFigure prototype;
    protected BezierFigure createdFigure;
    private CompositeEdit creationEdit;
    private int nodeCountBeforeDrag;

    public BezierTool(BezierFigure bezierFigure) {
        this(bezierFigure, null);
    }

    public BezierTool(BezierFigure bezierFigure, Map map) {
        this.prototype = bezierFigure;
        this.attributes = map;
    }

    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
        this.getView().clearSelection();
        this.getView().setCursor(Cursor.getPredefinedCursor(1));
    }

    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        this.getView().setCursor(Cursor.getDefaultCursor());
        if (this.createdFigure != null) {
            this.finishCreation(this.createdFigure);
            this.createdFigure = null;
            this.getDrawing().fireUndoableEditHappened(this.creationEdit);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (this.createdFigure == null) {
            this.finishWhenMouseReleased = null;
            this.creationEdit = new CompositeEdit("Figur erstellen");
            this.getDrawing().fireUndoableEditHappened(this.creationEdit);
            this.createdFigure = this.createFigure();
            this.createdFigure.addNode(new BezierPath.Node(this.getView().getConstrainer().constrainPoint(this.getView().viewToDrawing(this.anchor))));
            this.getDrawing().add(this.createdFigure);
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
        } else {
            if (mouseEvent.getClickCount() == 1) {
                this.addPointToFigure(this.getView().getConstrainer().constrainPoint(this.getView().viewToDrawing(this.anchor)));
            }
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
        }
    }

    protected BezierFigure createFigure() {
        BezierFigure bezierFigure = this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(bezierFigure);
        if (this.attributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
                bezierFigure.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return bezierFigure;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    protected void addPointToFigure(Point2D.Double double_) {
        int n = this.createdFigure.getNodeCount();
        this.createdFigure.willChange();
        if (n < 2) {
            this.createdFigure.basicAddNode(new BezierPath.Node(double_));
        } else {
            Point2D.Double double_2;
            Point2D.Double double_3 = this.createdFigure.getEndPoint();
            Point2D.Double double_4 = double_2 = n <= 1 ? double_3 : this.createdFigure.getPoint(n - 2, 0);
            if (!double_.equals(double_3)) {
                if (n > 1 && Geom.lineContainsPoint(double_.x, double_.y, double_2.x, double_2.y, double_3.x, double_3.y, (double)0.9f / this.getView().getScaleFactor())) {
                    this.createdFigure.basicSetPoint(n - 1, 0, double_);
                } else {
                    this.createdFigure.basicAddNode(new BezierPath.Node(double_));
                }
            }
        }
        this.createdFigure.changed();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.createdFigure != null) {
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    if (this.createdFigure.getNodeCount() <= 2) break;
                    Rectangle rectangle = new Rectangle(this.getView().drawingToView(this.createdFigure.getStartPoint()));
                    rectangle.grow(2, 2);
                    if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) break;
                    this.createdFigure.setClosed(true);
                    this.finishCreation(this.createdFigure);
                    this.getDrawing().fireUndoableEditHappened(this.creationEdit);
                    this.createdFigure = null;
                    this.fireToolDone();
                    break;
                }
                case 2: {
                    this.finishWhenMouseReleased = null;
                    this.finishCreation(this.createdFigure);
                    this.getDrawing().fireUndoableEditHappened(this.creationEdit);
                    this.createdFigure = null;
                    this.fireToolDone();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.finishWhenMouseReleased == Boolean.TRUE) {
            if (this.createdFigure.getNodeCount() > 2) {
                BezierPath bezierPath = Bezier.fitBezierCurve(this.createdFigure.getBezierPath(), 1.0);
                this.createdFigure.willChange();
                this.createdFigure.basicSetBezierPath(bezierPath);
                this.createdFigure.changed();
                this.finishCreation(this.createdFigure);
                this.createdFigure = null;
                this.getDrawing().fireUndoableEditHappened(this.creationEdit);
                this.finishWhenMouseReleased = null;
                this.fireToolDone();
                return;
            }
        } else if (this.finishWhenMouseReleased == null) {
            this.finishWhenMouseReleased = Boolean.FALSE;
        }
        if (this.createdFigure.getNodeCount() > this.nodeCountBeforeDrag + 1) {
            this.createdFigure.willChange();
            BezierPath bezierPath = new BezierPath();
            int n = this.createdFigure.getNodeCount();
            for (int i = this.nodeCountBeforeDrag; i < n; ++i) {
                bezierPath.add(this.createdFigure.getNode(this.nodeCountBeforeDrag));
                this.createdFigure.basicRemoveNode(this.nodeCountBeforeDrag);
            }
            bezierPath = Bezier.fitBezierCurve(bezierPath, 1.0);
            for (BezierPath.Node node : bezierPath) {
                this.createdFigure.basicAddNode(node);
            }
            this.nodeCountBeforeDrag = this.createdFigure.getNodeCount();
            this.createdFigure.changed();
        }
    }

    protected void finishCreation(BezierFigure bezierFigure) {
        this.getView().addToSelection(bezierFigure);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.createdFigure != null) {
            if (this.finishWhenMouseReleased == null) {
                this.finishWhenMouseReleased = Boolean.TRUE;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.addPointToFigure(this.getView().viewToDrawing(new Point(n, n2)));
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

