/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GeometryEdit;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxHandleKit {
    public static void addLeadHandles(Figure figure, Collection<Handle> collection) {
        collection.add(BoxHandleKit.southEast(figure));
        collection.add(BoxHandleKit.southWest(figure));
        collection.add(BoxHandleKit.northEast(figure));
        collection.add(BoxHandleKit.northWest(figure));
    }

    public static void addEdgeHandles(Figure figure, Collection<Handle> collection) {
        collection.add(BoxHandleKit.south(figure));
        collection.add(BoxHandleKit.north(figure));
        collection.add(BoxHandleKit.east(figure));
        collection.add(BoxHandleKit.west(figure));
    }

    public static void addBoxHandles(Figure figure, Collection<Handle> collection) {
        BoxHandleKit.addLeadHandles(figure, collection);
        BoxHandleKit.addEdgeHandles(figure, collection);
    }

    public static Handle south(Figure figure) {
        return new SouthHandle(figure);
    }

    public static Handle southEast(Figure figure) {
        return new SouthEastHandle(figure);
    }

    public static Handle southWest(Figure figure) {
        return new SouthWestHandle(figure);
    }

    public static Handle north(Figure figure) {
        return new NorthHandle(figure);
    }

    public static Handle northEast(Figure figure) {
        return new NorthEastHandle(figure);
    }

    public static Handle northWest(Figure figure) {
        return new NorthWestHandle(figure);
    }

    public static Handle east(Figure figure) {
        return new EastHandle(figure);
    }

    public static Handle west(Figure figure) {
        return new WestHandle(figure);
    }

    private static class WestHandle
    extends ResizeHandle {
        WestHandle(Figure figure) {
            super(figure, RelativeLocator.west());
        }

        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(double_2.x + double_2.width - 1.0, double_.x), double_2.y), new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(10);
        }
    }

    private static class SouthWestHandle
    extends ResizeHandle {
        SouthWestHandle(Figure figure) {
            super(figure, RelativeLocator.southWest());
        }

        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(double_2.x + double_2.width - 1.0, double_.x), double_2.y), new Point2D.Double(double_2.x + double_2.width, Math.max(double_2.y + 1.0, double_.y)));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(4);
        }
    }

    private static class SouthHandle
    extends ResizeHandle {
        SouthHandle(Figure figure) {
            super(figure, RelativeLocator.south());
        }

        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, double_2.y), new Point2D.Double(double_2.x + double_2.width, Math.max(double_2.y + 1.0, double_.y)));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(9);
        }
    }

    private static class SouthEastHandle
    extends ResizeHandle {
        SouthEastHandle(Figure figure) {
            super(figure, RelativeLocator.southEast());
        }

        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, double_2.y), new Point2D.Double(Math.max(double_2.x + 1.0, double_.x), Math.max(double_2.y + 1.0, double_.y)));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(5);
        }
    }

    private static class NorthWestHandle
    extends ResizeHandle {
        NorthWestHandle(Figure figure) {
            super(figure, RelativeLocator.northWest());
        }

        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(double_2.x + double_2.width - 1.0, double_.x), Math.min(double_2.y + double_2.height - 1.0, double_.y)), new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(6);
        }
    }

    private static class NorthHandle
    extends ResizeHandle {
        NorthHandle(Figure figure) {
            super(figure, RelativeLocator.north());
        }

        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, Math.min(double_2.y + double_2.height - 1.0, double_.y)), new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(8);
        }
    }

    private static class EastHandle
    extends ResizeHandle {
        EastHandle(Figure figure) {
            super(figure, RelativeLocator.east());
        }

        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, double_2.y), new Point2D.Double(Math.max(double_2.x + 1.0, double_.x), double_2.y + double_2.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(11);
        }
    }

    private static class NorthEastHandle
    extends ResizeHandle {
        NorthEastHandle(Figure figure) {
            super(figure, RelativeLocator.northEast());
        }

        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, Math.min(double_2.y + double_2.height - 1.0, double_.y)), new Point2D.Double(Math.max(double_2.x, double_.x), double_2.y + double_2.height));
        }

        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(7);
        }
    }

    private static class ResizeHandle
    extends LocatorHandle {
        private int dx;
        private int dy;
        Object geometry;

        ResizeHandle(Figure figure, Locator locator) {
            super(figure, locator);
        }

        public void trackStart(Point point, int n) {
            this.geometry = this.getOwner().getRestoreData();
            Point point2 = this.getLocation();
            this.dx = -point.x + point2.x;
            this.dy = -point.y + point2.y;
        }

        public void trackStep(Point point, Point point2, int n) {
            Point2D.Double double_ = this.view.viewToDrawing(new Point(point2.x + this.dx, point2.y + this.dy));
            this.view.getConstrainer().constrainPoint(double_);
            this.trackStepNormalized(double_);
        }

        public void trackEnd(Point point, Point point2, int n) {
            this.fireUndoableEditHappened(new GeometryEdit(this.getOwner(), this.geometry, this.getOwner().getRestoreData()));
        }

        protected void trackStepNormalized(Point2D.Double double_) {
        }

        protected void setBounds(Point2D.Double double_, Point2D.Double double_2) {
            Figure figure = this.getOwner();
            figure.willChange();
            Rectangle2D.Double double_3 = figure.getBounds();
            Rectangle2D.Double double_4 = new Rectangle2D.Double(Math.min(double_.x, double_2.x), Math.min(double_.y, double_2.y), Math.abs(double_.x - double_2.x), Math.abs(double_.y - double_2.y));
            double d = double_4.width / double_3.width;
            double d2 = double_4.height / double_3.height;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(-double_3.x, -double_3.y);
            if (!(Double.isNaN(d) || Double.isNaN(d2) || d == 1.0 && d2 == 1.0 || d < 1.0E-4 || d2 < 1.0E-4)) {
                figure.basicTransform(affineTransform);
                affineTransform.setToIdentity();
                affineTransform.scale(d, d2);
                figure.basicTransform(affineTransform);
                affineTransform.setToIdentity();
            }
            affineTransform.translate(double_4.x, double_4.y);
            figure.basicTransform(affineTransform);
            figure.changed();
        }
    }
}

