/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ChopBoxConnector;
import org.jhotdraw.draw.DiamondFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;

public class ChopDiamondConnector
extends ChopBoxConnector {
    public ChopDiamondConnector() {
    }

    public ChopDiamondConnector(Figure figure) {
        super(figure);
    }

    protected Point2D.Double chop(Figure figure, Point2D.Double double_) {
        double d;
        double d2;
        figure = this.getConnectorTarget(figure);
        Rectangle2D.Double double_2 = figure.getBounds();
        if (DiamondFigure.IS_QUADRATIC.get(figure).booleanValue()) {
            d2 = Math.max(double_2.width, double_2.height);
            double_2.x -= (d2 - double_2.width) / 2.0;
            double_2.y -= (d2 - double_2.height) / 2.0;
            double_2.width = double_2.height = d2;
        }
        switch (AttributeKeys.STROKE_PLACEMENT.get(figure)) {
            case INSIDE: {
                d = 0.0;
                d2 = 0.0;
                break;
            }
            case OUTSIDE: {
                double d3 = Math.sqrt(double_2.width * double_2.width + double_2.height * double_2.height);
                double d4 = AttributeKeys.getStrokeTotalWidth(figure) * 2.0 / d3;
                d2 = d4 * double_2.height;
                d = d4 * double_2.width;
                break;
            }
            default: {
                double d3 = Math.sqrt(double_2.width * double_2.width + double_2.height * double_2.height);
                double d4 = AttributeKeys.getStrokeTotalWidth(figure) / d3;
                d2 = d4 * double_2.height;
                d = d4 * double_2.width;
            }
        }
        Geom.grow(double_2, d2, d);
        Point2D.Double double_3 = new Point2D.Double(double_2.x + double_2.width / 2.0, double_2.y + double_2.height / 2.0);
        Point2D.Double double_4 = new Point2D.Double(double_2.x + double_2.width / 2.0, double_2.y + double_2.height);
        Point2D.Double double_5 = new Point2D.Double(double_2.x + double_2.width / 2.0, double_2.y);
        if (double_2.contains(double_)) {
            if (double_.y > double_2.y && double_.y < double_2.y + double_2.height / 2.0) {
                return double_4;
            }
            return double_5;
        }
        double d5 = Geom.pointToAngle(double_2, double_);
        Point2D.Double double_6 = new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height / 2.0);
        Point2D.Double double_7 = new Point2D.Double(double_2.x, double_2.y + double_2.height / 2.0);
        Point2D.Double double_8 = null;
        if (d5 > 0.0 && d5 < 1.57) {
            double_8 = Geom.intersect(double_6.x, double_6.y, double_4.x, double_4.y, double_3.x, double_3.y, double_.x, double_.y);
        } else if (d5 > 1.575 && d5 < 3.14) {
            double_8 = Geom.intersect(double_4.x, double_4.y, double_7.x, double_7.y, double_3.x, double_3.y, double_.x, double_.y);
        } else if (d5 > -3.14 && d5 < -1.575) {
            double_8 = Geom.intersect(double_7.x, double_7.y, double_5.x, double_5.y, double_3.x, double_3.y, double_.x, double_.y);
        } else if (d5 > -1.57 && d5 < 0.0) {
            double_8 = Geom.intersect(double_5.x, double_5.y, double_6.x, double_6.y, double_3.x, double_3.y, double_.x, double_.y);
        }
        if (double_8 == null) {
            double_8 = Geom.angleToPoint(double_2, d5);
        }
        return double_8;
    }
}

