/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ChopBoxConnector;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.RoundRectangleFigure;
import org.jhotdraw.geom.Geom;

public class ChopRoundRectConnector
extends ChopBoxConnector {
    public ChopRoundRectConnector() {
    }

    public ChopRoundRectConnector(Figure figure) {
        super(figure);
    }

    protected Point2D.Double chop(Figure figure, Point2D.Double double_) {
        double d;
        figure = this.getConnectorTarget(figure);
        RoundRectangleFigure roundRectangleFigure = (RoundRectangleFigure)figure;
        Rectangle2D.Double double_2 = roundRectangleFigure.getBounds();
        switch (AttributeKeys.STROKE_PLACEMENT.get(figure)) {
            default: {
                d = AttributeKeys.getStrokeTotalWidth(figure) / 2.0;
                break;
            }
            case OUTSIDE: {
                d = AttributeKeys.getStrokeTotalWidth(figure);
                break;
            }
            case INSIDE: {
                d = 0.0;
            }
        }
        Geom.grow(double_2, d, d);
        Rectangle2D.Double double_3 = (Rectangle2D.Double)double_2.clone();
        double d2 = -(roundRectangleFigure.getArcWidth() + d * 2.0) / 2.0;
        double d3 = -(roundRectangleFigure.getArcHeight() + d * 2.0) / 2.0;
        double_3.x -= d2;
        double_3.y -= d3;
        double_3.width += d2 * 2.0;
        double_3.height += d3 * 2.0;
        double d4 = Geom.pointToAngle(double_2, double_);
        Point2D.Double double_4 = Geom.angleToPoint(double_2, Geom.pointToAngle(double_2, double_));
        if (double_4.x == double_2.x || double_4.x == double_2.x + double_2.width) {
            double_4.y = Math.min(Math.max(double_4.y, double_3.y), double_3.y + double_3.height);
        } else {
            double_4.x = Math.min(Math.max(double_4.x, double_3.x), double_3.x + double_3.width);
        }
        return double_4;
    }
}

