/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.ChopDiamondConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.geom.Geom;

public class DiamondFigure
extends AttributedFigure {
    public static final AttributeKey<Boolean> IS_QUADRATIC = new AttributeKey<Boolean>("isQuadratic", false);
    private Rectangle2D.Double rectangle;

    public DiamondFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public DiamondFigure(double d, double d2, double d3, double d4) {
        this.rectangle = new Rectangle2D.Double(d, d2, d3, d4);
    }

    protected void drawFill(Graphics2D graphics2D) {
        double d;
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        if (this.isQuadratic()) {
            d = Math.max(double_.width, double_.height);
            double_.x -= (d - double_.width) / 2.0;
            double_.y -= (d - double_.height) / 2.0;
            double_.width = double_.height = d;
        }
        if ((d = AttributeKeys.getPerpendicularFillGrowth(this)) == 0.0) {
            double d2 = 0.0;
            double d3 = 0.0;
        } else {
            double d4 = double_.width / 2.0;
            double d5 = double_.height / 2.0;
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            double d7 = d / d6;
            double d8 = d7 * d4;
            double d9 = d7 * d5;
            double d10 = d8 * d8 / d9 + d9;
            double d11 = d9 * d9 / d8 + d8;
            Geom.grow(double_, d10, d11);
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(double_.x + double_.width / 2.0), (float)double_.y);
        generalPath.lineTo((float)(double_.x + double_.width), (float)(double_.y + double_.height / 2.0));
        generalPath.lineTo((float)(double_.x + double_.width / 2.0), (float)(double_.y + double_.height));
        generalPath.lineTo((float)double_.x, (float)(double_.y + double_.height / 2.0));
        generalPath.closePath();
        graphics2D.fill(generalPath);
    }

    protected void drawStroke(Graphics2D graphics2D) {
        double d;
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        if (this.isQuadratic()) {
            d = Math.max(double_.width, double_.height);
            double_.x -= (d - double_.width) / 2.0;
            double_.y -= (d - double_.height) / 2.0;
            double_.width = double_.height = d;
        }
        if ((d = AttributeKeys.getPerpendicularDrawGrowth(this)) == 0.0) {
            double d2 = 0.0;
            double d3 = 0.0;
        } else {
            double d4 = double_.width / 2.0;
            double d5 = double_.height / 2.0;
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            double d7 = d / d6;
            double d8 = d7 * d4;
            double d9 = d7 * d5;
            double d10 = d8 * d8 / d9 + d9;
            double d11 = d9 * d9 / d8 + d8;
            Geom.grow(double_, d10, d11);
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(double_.x + double_.width / 2.0), (float)double_.y);
        generalPath.lineTo((float)(double_.x + double_.width), (float)(double_.y + double_.height / 2.0));
        generalPath.lineTo((float)(double_.x + double_.width / 2.0), (float)(double_.y + double_.height));
        generalPath.lineTo((float)double_.x, (float)(double_.y + double_.height / 2.0));
        generalPath.closePath();
        graphics2D.draw(generalPath);
    }

    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        return double_;
    }

    public Rectangle2D.Double getFigureDrawBounds() {
        double d;
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        if (this.isQuadratic()) {
            d = Math.max(double_.width, double_.height);
            double_.x -= (d - double_.width) / 2.0;
            double_.y -= (d - double_.height) / 2.0;
            double_.width = double_.height = d;
        }
        if ((d = AttributeKeys.getPerpendicularHitGrowth(this)) == 0.0) {
            double d2 = 0.0;
            double d3 = 0.0;
        } else {
            double d4 = double_.width / 2.0;
            double d5 = double_.height / 2.0;
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            double d7 = d / d6;
            double d8 = d7 * d4;
            double d9 = d7 * d5;
            double d10 = d8 * d8 / d9 + d9;
            double d11 = d9 * d9 / d8 + d8;
            Geom.grow(double_, d10, d11);
        }
        return double_;
    }

    public boolean contains(Point2D.Double double_) {
        double d;
        Rectangle2D.Double double_2 = (Rectangle2D.Double)this.rectangle.clone();
        if (this.isQuadratic()) {
            d = Math.max(double_2.width, double_2.height);
            double_2.x -= (d - double_2.width) / 2.0;
            double_2.y -= (d - double_2.height) / 2.0;
            double_2.width = double_2.height = d;
        }
        if ((d = AttributeKeys.getPerpendicularFillGrowth(this)) == 0.0) {
            double d2 = 0.0;
            double d3 = 0.0;
        } else {
            double d4 = double_2.width / 2.0;
            double d5 = double_2.height / 2.0;
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            double d7 = d / d6;
            double d8 = d7 * d4;
            double d9 = d7 * d5;
            double d10 = d8 * d8 / d9 + d9;
            double d11 = d9 * d9 / d8 + d8;
            Geom.grow(double_2, d10, d11);
        }
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(double_2.x + double_2.width / 2.0), (float)double_2.y);
        generalPath.lineTo((float)(double_2.x + double_2.width), (float)(double_2.y + double_2.height / 2.0));
        generalPath.lineTo((float)(double_2.x + double_2.width / 2.0), (float)(double_2.y + double_2.height));
        generalPath.lineTo((float)double_2.x, (float)(double_2.y + double_2.height / 2.0));
        generalPath.closePath();
        return generalPath.contains(double_);
    }

    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.rectangle.x = Math.min(double_.x, double_2.x);
        this.rectangle.y = Math.min(double_.y, double_2.y);
        this.rectangle.width = Math.max(0.1, Math.abs(double_2.x - double_.x));
        this.rectangle.height = Math.max(0.1, Math.abs(double_2.y - double_.y));
    }

    public void basicTransform(AffineTransform affineTransform) {
        Point2D.Double double_ = this.getStartPoint();
        Point2D.Double double_2 = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
    }

    public void restoreTo(Object object) {
        Rectangle2D.Double double_ = (Rectangle2D.Double)object;
        this.rectangle.x = double_.x;
        this.rectangle.y = double_.y;
        this.rectangle.width = double_.width;
        this.rectangle.height = double_.height;
    }

    public Object getRestoreData() {
        return this.rectangle.clone();
    }

    public boolean isQuadratic() {
        Boolean bl = (Boolean)this.getAttribute(IS_QUADRATIC);
        return bl == null ? false : bl;
    }

    public void setQuadratic(boolean bl) {
        this.setAttribute(IS_QUADRATIC, bl);
    }

    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return new ChopDiamondConnector(this);
    }

    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return new ChopDiamondConnector(this);
    }

    public DiamondFigure clone() {
        DiamondFigure diamondFigure = (DiamondFigure)super.clone();
        diamondFigure.rectangle = (Rectangle2D.Double)this.rectangle.clone();
        return diamondFigure;
    }
}

