/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;

public class DragTracker
extends AbstractTool {
    Figure anchorFigure;
    Point2D.Double oldPoint;
    Point2D.Double anchorPoint;
    private boolean isDragging;

    public DragTracker(Figure figure) {
        this.anchorFigure = figure;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateCursor(this.editor.findView((Container)mouseEvent.getSource()), new Point(mouseEvent.getX(), mouseEvent.getY()));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        DrawingView drawingView = this.getView();
        if (mouseEvent.isShiftDown()) {
            drawingView.setHandleDetailLevel(0);
            drawingView.toggleSelection(this.anchorFigure);
            if (!drawingView.isFigureSelected(this.anchorFigure)) {
                this.anchorFigure = null;
            }
        } else if (!drawingView.isFigureSelected(this.anchorFigure)) {
            drawingView.setHandleDetailLevel(0);
            drawingView.clearSelection();
            drawingView.addToSelection(this.anchorFigure);
        }
        Point2D.Double double_ = new Point2D.Double(Double.MAX_VALUE, Double.MAX_VALUE);
        for (Figure figure : drawingView.getSelectedFigures()) {
            Rectangle2D.Double double_2 = figure.getBounds();
            double_.x = Math.min(double_.x, double_2.x);
            double_.y = Math.min(double_.y, double_2.y);
        }
        Point2D.Double double_3 = drawingView.getConstrainer().constrainPoint(new Point2D.Double(double_.x, double_.y));
        this.oldPoint = drawingView.getConstrainer().constrainPoint(drawingView.viewToDrawing(new Point(mouseEvent.getX(), mouseEvent.getY())));
        this.oldPoint.x += double_.x - double_3.x;
        this.oldPoint.y += double_.y - double_3.y;
        this.anchorPoint = this.oldPoint;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        DrawingView drawingView = this.getView();
        this.isDragging = false;
        if (false) {
            this.isDragging = true;
            this.updateCursor(this.editor.findView((Container)mouseEvent.getSource()), new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
        Point2D.Double double_ = drawingView.getConstrainer().constrainPoint(drawingView.viewToDrawing(new Point(mouseEvent.getX(), mouseEvent.getY())));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(double_.x - this.oldPoint.x, double_.y - this.oldPoint.y);
        for (Figure figure : drawingView.getSelectedFigures()) {
            figure.willChange();
            figure.basicTransform(affineTransform);
            figure.changed();
        }
        this.oldPoint = double_;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        this.isDragging = false;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.updateCursor(this.editor.findView((Container)mouseEvent.getSource()), new Point(mouseEvent.getX(), mouseEvent.getY()));
        Point2D.Double double_ = this.getView().getConstrainer().constrainPoint(this.getView().viewToDrawing(new Point(n, n2)));
        LinkedList<Figure> linkedList = new LinkedList<Figure>(this.getView().getSelectedFigures());
        Figure figure = this.getDrawing().findFigureExcept(double_, linkedList);
        if (figure != null) {
            boolean bl = figure.handleDrop(double_, linkedList, this.getView());
            if (bl) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(this.anchorPoint.x - this.oldPoint.x, this.anchorPoint.y - this.oldPoint.y);
                for (Figure figure2 : linkedList) {
                    figure2.willChange();
                    figure2.basicTransform(affineTransform);
                    figure2.changed();
                }
            } else {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(-this.anchorPoint.x + this.oldPoint.x, -this.anchorPoint.y + this.oldPoint.y);
                if (!affineTransform.isIdentity()) {
                    this.getDrawing().fireUndoableEditHappened(new TransformEdit(linkedList, affineTransform));
                }
            }
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(-this.anchorPoint.x + this.oldPoint.x, -this.anchorPoint.y + this.oldPoint.y);
            if (!affineTransform.isIdentity()) {
                this.getDrawing().fireUndoableEditHappened(new TransformEdit(linkedList, affineTransform));
            }
        }
        this.fireToolDone();
    }
}

