/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.Liner;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElbowLiner
implements Liner,
DOMStorable {
    @Override
    public Collection<Handle> createHandles(BezierPath bezierPath) {
        return null;
    }

    @Override
    public void lineout(ConnectionFigure connectionFigure) {
        BezierPath bezierPath = ((LineConnectionFigure)connectionFigure).getBezierPath();
        Connector connector = connectionFigure.getStartConnector();
        Connector connector2 = connectionFigure.getEndConnector();
        if (connector == null || connector2 == null || bezierPath == null) {
            return;
        }
        Point2D.Double double_ = connector.findStart(connectionFigure);
        Point2D.Double double_2 = connector2.findEnd(connectionFigure);
        bezierPath.clear();
        bezierPath.add(new BezierPath.Node(double_.x, double_.y));
        if (double_.x == double_2.x || double_.y == double_2.y) {
            bezierPath.add(new BezierPath.Node(double_2.x, double_2.y));
        } else {
            int n;
            Rectangle2D.Double double_3 = connector.getBounds();
            double_3.x += 5.0;
            double_3.y += 5.0;
            double_3.width -= 10.0;
            double_3.height -= 10.0;
            Rectangle2D.Double double_4 = connector2.getBounds();
            double_4.x += 5.0;
            double_4.y += 5.0;
            double_4.width -= 10.0;
            double_4.height -= 10.0;
            int n2 = double_3.outcode(double_);
            if (n2 == 0) {
                n2 = Geom.outcode(double_3, double_4);
            }
            if ((n = double_4.outcode(double_2)) == 0) {
                n = Geom.outcode(double_4, double_3);
            }
            if ((n2 & 0xA) != 0 && (n & 0xA) != 0) {
                bezierPath.add(new BezierPath.Node(double_.x, (double_.y + double_2.y) / 2.0));
                bezierPath.add(new BezierPath.Node(double_2.x, (double_.y + double_2.y) / 2.0));
            } else if ((n2 & 5) != 0 && (n & 5) != 0) {
                bezierPath.add(new BezierPath.Node((double_.x + double_2.x) / 2.0, double_.y));
                bezierPath.add(new BezierPath.Node((double_.x + double_2.x) / 2.0, double_2.y));
            }
            bezierPath.add(new BezierPath.Node(double_2.x, double_2.y));
        }
        bezierPath.invalidatePath();
    }

    @Override
    public void read(DOMInput dOMInput) {
    }

    @Override
    public void write(DOMOutput dOMOutput) {
    }

    @Override
    public Liner clone() {
        try {
            return (Liner)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            InternalError internalError = new InternalError(cloneNotSupportedException.getMessage());
            internalError.initCause(cloneNotSupportedException);
            throw internalError;
        }
    }
}

