/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.TextHolder;

public class FloatingTextArea {
    protected JScrollPane editScrollContainer;
    protected JTextArea editWidget = new JTextArea();
    protected DrawingView view;

    public FloatingTextArea() {
        this.editWidget.setWrapStyleWord(true);
        this.editWidget.setLineWrap(true);
        this.editScrollContainer = new JScrollPane(this.editWidget, 22, 31);
        this.editScrollContainer.setCursor(Cursor.getPredefinedCursor(0));
        this.editScrollContainer.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void createOverlay(DrawingView drawingView) {
        this.createOverlay(drawingView, null);
    }

    public void requestFocus() {
        this.editWidget.requestFocus();
    }

    public void createOverlay(DrawingView drawingView, TextHolder textHolder) {
        drawingView.getContainer().add((Component)this.editScrollContainer, 0);
        if (textHolder != null) {
            Font font = textHolder.getFont();
            font = font.deriveFont(font.getStyle(), (float)((double)font.getSize() * drawingView.getScaleFactor()));
            this.editWidget.setFont(font);
            this.editWidget.setForeground(textHolder.getTextColor());
            this.editWidget.setBackground(textHolder.getFillColor());
            this.editWidget.setTabSize(textHolder.getTabSize());
        }
        this.view = drawingView;
    }

    public void setBounds(Rectangle2D.Double double_, String string) {
        this.editWidget.setText(string);
        this.editScrollContainer.setBounds(this.view.drawingToView(double_));
        this.editScrollContainer.setVisible(true);
        this.editWidget.setCaretPosition(0);
        this.editWidget.requestFocus();
    }

    public String getText() {
        return this.editWidget.getText();
    }

    public Dimension getPreferredSize(int n) {
        return new Dimension(this.editWidget.getWidth(), this.editWidget.getHeight());
    }

    public void endOverlay() {
        this.view.getContainer().requestFocus();
        if (this.editScrollContainer != null) {
            this.editScrollContainer.setVisible(false);
            this.view.getContainer().remove(this.editScrollContainer);
            Rectangle rectangle = this.editScrollContainer.getBounds();
            this.view.getContainer().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

