/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.jhotdraw.draw.FontSizeLocator;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.TextHolder;
import org.jhotdraw.undo.CompositeEdit;

public class FontSizeHandle
extends LocatorHandle {
    private float oldSize;
    private CompositeEdit edit;

    public FontSizeHandle(TextHolder textHolder) {
        super(textHolder, new FontSizeLocator());
    }

    public FontSizeHandle(TextHolder textHolder, Locator locator) {
        super(textHolder, locator);
    }

    public void draw(Graphics2D graphics2D) {
        this.drawDiamond(graphics2D, Color.yellow, Color.black);
    }

    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(9);
    }

    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.getLocation());
        rectangle.grow(this.getHandlesize() / 2 + 1, this.getHandlesize() / 2 + 1);
        return rectangle;
    }

    public void trackStart(Point point, int n) {
        this.edit = new CompositeEdit("Schriftgr\u00f6sse");
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
        TextHolder textHolder = (TextHolder)this.getOwner();
        this.oldSize = textHolder.getFontSize();
    }

    public void trackStep(Point point, Point point2, int n) {
        TextHolder textHolder = (TextHolder)this.getOwner();
        float f = (float)Math.max(1.0, (double)this.oldSize + this.view.viewToDrawing((Point)new Point((int)0, (int)(point2.y - point.y))).y);
        textHolder.setFontSize(f);
    }

    public void trackEnd(Point point, Point point2, int n) {
        this.view.getDrawing().fireUndoableEditHappened(this.edit);
    }
}

