/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DrawingView;

public class GridConstrainer
implements Constrainer {
    private double width;
    private double height;
    private static Color minorColor = new Color(0xEBEBEB);
    private static Color majorColor = new Color(0xCACACA);

    public GridConstrainer(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Width or height is <= 0");
        }
        this.width = d;
        this.height = d2;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Point2D.Double constrainPoint(Point2D.Double double_) {
        double_.x = (double)Math.round(double_.x / this.width) * this.width;
        double_.y = (double)Math.round(double_.y / this.height) * this.height;
        return double_;
    }

    public String toString() {
        return super.toString() + "[" + this.width + "," + this.height + "]";
    }

    public boolean isVisible() {
        return this.width > 1.0 && this.height > 1.0;
    }

    public void draw(Graphics2D graphics2D, DrawingView drawingView) {
        if (this.isVisible()) {
            int n;
            int n2;
            AffineTransform affineTransform = drawingView.getDrawingToViewTransform();
            Rectangle rectangle = graphics2D.getClipBounds();
            Rectangle2D.Double double_ = drawingView.viewToDrawing(rectangle);
            Point2D.Double double_2 = this.constrainPoint(new Point2D.Double(double_.x, double_.y));
            Point2D.Double double_3 = new Point2D.Double();
            Point2D.Double double_4 = new Point2D.Double();
            if (this.width * drawingView.getScaleFactor() > 1.0) {
                graphics2D.setColor(minorColor);
                n2 = (int)((double_2.x + double_.width) / this.width) + 1;
                for (n = (int)(double_2.x / this.width); n <= n2; ++n) {
                    graphics2D.setColor(n % 5 == 0 ? majorColor : minorColor);
                    double_3.x = this.width * (double)n;
                    affineTransform.transform(double_3, double_4);
                    graphics2D.drawLine((int)double_4.x, rectangle.y, (int)double_4.x, rectangle.y + rectangle.height);
                }
            }
            if (this.height * drawingView.getScaleFactor() > 1.0) {
                graphics2D.setColor(minorColor);
                n2 = (int)((double_2.y + double_.height) / this.height) + 1;
                for (n = (int)(double_2.y / this.height); n <= n2; ++n) {
                    graphics2D.setColor(n % 5 == 0 ? majorColor : minorColor);
                    double_3.y = this.height * (double)n;
                    affineTransform.transform(double_3, double_4);
                    graphics2D.drawLine(rectangle.x, (int)double_4.y, rectangle.x + rectangle.width, (int)double_4.y);
                }
            }
        }
    }
}

