/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TransformEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveHandle
extends LocatorHandle {
    private Point2D.Double oldPoint;
    private Object geometry;

    public MoveHandle(Figure figure, Locator locator) {
        super(figure, locator);
    }

    public static void addMoveHandles(Figure figure, Collection<Handle> collection) {
        collection.add(MoveHandle.southEast(figure));
        collection.add(MoveHandle.southWest(figure));
        collection.add(MoveHandle.northEast(figure));
        collection.add(MoveHandle.northWest(figure));
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        this.drawRectangle(graphics2D, Color.white, Color.black);
    }

    @Override
    public void trackStart(Point point, int n) {
        this.oldPoint = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point));
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
        Figure figure = this.getOwner();
        Point2D.Double double_ = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(point2));
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(double_.x - this.oldPoint.x, double_.y - this.oldPoint.y);
        figure.willChange();
        figure.basicTransform(affineTransform);
        figure.changed();
        this.oldPoint = double_;
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(point2.x - point.x, point2.y - point.y);
        this.fireUndoableEditHappened(new TransformEdit(this.getOwner(), affineTransform));
    }

    public static Handle south(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.south());
    }

    public static Handle southEast(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.southEast());
    }

    public static Handle southWest(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.southWest());
    }

    public static Handle north(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.north());
    }

    public static Handle northEast(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.northEast());
    }

    public static Handle northWest(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.northWest());
    }

    public static Handle east(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.east());
    }

    public static Handle west(Figure figure) {
        return new MoveHandle(figure, RelativeLocator.west());
    }
}

