/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.draw.AbstractDrawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureEvent;
import org.jhotdraw.draw.FigureLayerComparator;
import org.jhotdraw.draw.FigureListener;
import org.jhotdraw.geom.QuadTree2DDouble;
import org.jhotdraw.util.ReversedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTreeDrawing
extends AbstractDrawing
implements FigureListener,
UndoableEditListener {
    private ArrayList<Figure> figures = new ArrayList();
    private QuadTree2DDouble<Figure> quadTree = new QuadTree2DDouble();
    private boolean needsSorting = false;

    @Override
    protected int indexOf(Figure figure) {
        return this.figures.indexOf(figure);
    }

    @Override
    public void basicAdd(int n, Figure figure) {
        this.figures.add(n, figure);
        this.quadTree.add(figure, figure.getDrawBounds());
        figure.addFigureListener(this);
        figure.addUndoableEditListener(this);
        this.needsSorting = true;
    }

    @Override
    public void basicRemove(Figure figure) {
        this.figures.remove(figure);
        this.quadTree.remove(figure);
        figure.removeFigureListener(this);
        figure.removeUndoableEditListener(this);
        this.needsSorting = true;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Collection<Figure> collection = this.quadTree.findIntersects(graphics2D.getClipBounds().getBounds2D());
        Collection<Figure> collection2 = this.sort(collection);
        this.draw(graphics2D, collection2);
    }

    @Override
    public Collection<Figure> sort(Collection<Figure> collection) {
        this.ensureSorted();
        ArrayList<Figure> arrayList = new ArrayList<Figure>(collection.size());
        for (Figure figure : this.figures) {
            if (!collection.contains(figure)) continue;
            arrayList.add(figure);
        }
        return arrayList;
    }

    public void draw(Graphics2D graphics2D, Collection<Figure> collection) {
        for (Figure figure : collection) {
            figure.draw(graphics2D);
        }
    }

    @Override
    public void figureAreaInvalidated(FigureEvent figureEvent) {
        this.fireAreaInvalidated(figureEvent.getInvalidatedArea());
    }

    @Override
    public void figureChanged(FigureEvent figureEvent) {
        this.quadTree.remove(figureEvent.getFigure());
        this.quadTree.add(figureEvent.getFigure(), figureEvent.getFigure().getDrawBounds());
        this.needsSorting = true;
        this.fireAreaInvalidated(figureEvent.getInvalidatedArea());
    }

    @Override
    public void figureAdded(FigureEvent figureEvent) {
    }

    @Override
    public void figureRemoved(FigureEvent figureEvent) {
    }

    @Override
    public void figureRequestRemove(FigureEvent figureEvent) {
        this.remove(figureEvent.getFigure());
    }

    public Collection<Figure> getFigures(Rectangle2D.Double double_) {
        return this.quadTree.findInside(double_);
    }

    @Override
    public Collection<Figure> getFigures() {
        return Collections.unmodifiableCollection(this.figures);
    }

    @Override
    public Figure findFigureInside(Point2D.Double double_) {
        Collection<Figure> collection = this.quadTree.findContains(double_);
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (!collection.contains(figure) || !figure.contains(double_)) continue;
            return figure.findFigureInside(double_);
        }
        return null;
    }

    @Override
    public List<Figure> getFiguresFrontToBack() {
        this.ensureSorted();
        return new ReversedList<Figure>(this.figures);
    }

    @Override
    public Figure findFigure(Point2D.Double double_) {
        Collection<Figure> collection = this.quadTree.findContains(double_);
        switch (collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure figure = collection.iterator().next();
                return figure.contains(double_) ? figure : null;
            }
        }
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (!collection.contains(figure) || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    @Override
    public Figure findFigureExcept(Point2D.Double double_, Figure figure) {
        Collection<Figure> collection = this.quadTree.findContains(double_);
        switch (collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure figure2 = collection.iterator().next();
                return figure2 == figure || !figure2.contains(double_) ? null : figure2;
            }
        }
        for (Figure figure3 : this.getFiguresFrontToBack()) {
            if (figure3 == figure || !figure3.contains(double_)) continue;
            return figure3;
        }
        return null;
    }

    public Figure findFigureExcept(Point2D.Double double_, Collection collection) {
        Collection<Figure> collection2 = this.quadTree.findContains(double_);
        switch (collection2.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Figure figure = collection2.iterator().next();
                return !collection.contains(figure) || !figure.contains(double_) ? null : figure;
            }
        }
        for (Figure figure : this.getFiguresFrontToBack()) {
            if (collection.contains(figure) || !figure.contains(double_)) continue;
            return figure;
        }
        return null;
    }

    @Override
    public Collection<Figure> findFigures(Rectangle2D.Double double_) {
        Collection<Figure> collection = this.quadTree.findIntersects(double_);
        switch (collection.size()) {
            case 0: 
            case 1: {
                return collection;
            }
        }
        return this.sort(collection);
    }

    @Override
    public Collection<Figure> findFiguresWithin(Rectangle2D.Double double_) {
        Collection<Figure> collection = this.findFigures(double_);
        ArrayList<Figure> arrayList = new ArrayList<Figure>(collection.size());
        for (Figure figure : collection) {
            if (!double_.contains(figure.getBounds())) continue;
            arrayList.add(figure);
        }
        return arrayList;
    }

    @Override
    public void bringToFront(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    @Override
    public void sendToBack(Figure figure) {
        if (this.figures.remove(figure)) {
            this.figures.add(0, figure);
            this.needsSorting = true;
            this.fireAreaInvalidated(figure.getDrawBounds());
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.fireUndoableEditHappened(undoableEditEvent.getEdit());
    }

    @Override
    public void figureAttributeChanged(FigureEvent figureEvent) {
    }

    @Override
    public boolean contains(Figure figure) {
        return this.figures.contains(figure);
    }

    private void ensureSorted() {
        if (this.needsSorting) {
            Collections.sort(this.figures, FigureLayerComparator.INSTANCE);
            this.needsSorting = false;
        }
    }
}

