/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jhotdraw.draw.AbstractTool;

public class SelectAreaTracker
extends AbstractTool {
    private Rectangle rubberBand = new Rectangle();

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        this.clearRubberBand();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.selectGroup(mouseEvent.isShiftDown());
        this.clearRubberBand();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Rectangle rectangle = (Rectangle)this.rubberBand.clone();
        this.rubberBand.setBounds(Math.min(this.anchor.x, mouseEvent.getX()), Math.min(this.anchor.y, mouseEvent.getY()), Math.abs(this.anchor.x - mouseEvent.getX()), Math.abs(this.anchor.y - mouseEvent.getY()));
        rectangle = rectangle.isEmpty() ? (Rectangle)this.rubberBand.clone() : rectangle.union(this.rubberBand);
        this.fireAreaInvalidated(rectangle);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.clearRubberBand();
        this.updateCursor(this.editor.findView((Container)mouseEvent.getSource()), new Point(mouseEvent.getX(), mouseEvent.getY()));
    }

    private void clearRubberBand() {
        if (this.rubberBand.width > 0) {
            this.fireAreaInvalidated(this.rubberBand);
            this.rubberBand.width = 0;
        }
    }

    public void draw(Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(this.rubberBand.x, this.rubberBand.y, this.rubberBand.width - 1, this.rubberBand.height - 1);
    }

    private void selectGroup(boolean bl) {
        this.getView().addToSelection(this.getView().findFiguresWithin(this.rubberBand));
    }
}

