/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.jhotdraw.draw.AbstractTool;
import org.jhotdraw.draw.DragTracker;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleTracker;
import org.jhotdraw.draw.SelectAreaTracker;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;

public class SelectionTool
extends AbstractTool
implements ToolListener {
    private Tool tracker = this.createAreaTracker();

    public SelectionTool() {
        this.tracker.addToolListener(this);
    }

    public void activate(DrawingEditor drawingEditor) {
        super.activate(drawingEditor);
        this.tracker.activate(drawingEditor);
    }

    public void deactivate(DrawingEditor drawingEditor) {
        super.deactivate(drawingEditor);
        this.tracker.deactivate(drawingEditor);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.tracker.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.tracker.keyReleased(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.tracker.keyTyped(keyEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.tracker.mouseClicked(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.tracker.mouseDragged(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        this.tracker.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this.tracker.mouseExited(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.tracker.mouseMoved(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.tracker.mouseReleased(mouseEvent);
    }

    public void draw(Graphics2D graphics2D) {
        this.tracker.draw(graphics2D);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        DrawingView drawingView = this.getView();
        Handle handle = drawingView.findHandle(this.anchor);
        Tool tool = null;
        if (handle != null) {
            tool = this.createHandleTracker(handle);
        } else {
            Figure figure = drawingView.findFigure(this.anchor);
            if (figure != null) {
                tool = this.createDragTracker(figure);
            } else {
                if (!mouseEvent.isShiftDown()) {
                    drawingView.clearSelection();
                    drawingView.setHandleDetailLevel(0);
                }
                tool = this.createAreaTracker();
            }
        }
        if (tool != null) {
            this.setTracker(tool);
        }
        this.tracker.mousePressed(mouseEvent);
    }

    protected void setTracker(Tool tool) {
        if (this.tracker != null) {
            this.tracker.deactivate(this.getEditor());
            this.tracker.removeToolListener(this);
        }
        this.tracker = tool;
        if (this.tracker != null) {
            this.tracker.activate(this.getEditor());
            this.tracker.addToolListener(this);
        }
    }

    protected Tool createHandleTracker(Handle handle) {
        return new HandleTracker(handle, this.getView().getCompatibleHandles(handle));
    }

    protected Tool createDragTracker(Figure figure) {
        return new DragTracker(figure);
    }

    protected Tool createAreaTracker() {
        return new SelectAreaTracker();
    }

    public void toolStarted(ToolEvent toolEvent) {
    }

    public void toolDone(ToolEvent toolEvent) {
        Tool tool = this.createAreaTracker();
        if (tool != null) {
            if (this.tracker != null) {
                this.tracker.deactivate(this.getEditor());
                this.tracker.removeToolListener(this);
            }
            this.tracker = tool;
            this.tracker.activate(this.getEditor());
            this.tracker.addToolListener(this);
        }
        this.fireToolDone();
    }

    public void areaInvalidated(ToolEvent toolEvent) {
        this.fireAreaInvalidated(toolEvent.getInvalidatedArea());
    }
}

