/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FloatingTextArea;
import org.jhotdraw.draw.TextHolder;
import org.jhotdraw.geom.Insets2DDouble;

public class TextAreaTool
extends CreationTool
implements ActionListener {
    private FloatingTextArea textArea;
    private TextHolder typingTarget;

    public TextAreaTool(TextHolder textHolder) {
        super(textHolder);
    }

    public void deactivate(DrawingEditor drawingEditor) {
        this.endEdit();
        super.deactivate(drawingEditor);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        TextHolder textHolder = null;
        Figure figure = this.getDrawing().findFigureInside(this.getView().viewToDrawing(new Point(mouseEvent.getX(), mouseEvent.getY())));
        if (figure instanceof TextHolder && !(textHolder = (TextHolder)figure).isEditable()) {
            textHolder = null;
        }
        if (textHolder != null) {
            this.createdFigure = null;
            this.beginEdit(textHolder);
            return;
        }
        if (this.typingTarget != null) {
            this.endEdit();
            this.fireToolDone();
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    protected void beginEdit(TextHolder textHolder) {
        if (this.textArea == null) {
            this.textArea = new FloatingTextArea();
        }
        if (textHolder != this.typingTarget && this.typingTarget != null) {
            this.endEdit();
        }
        this.textArea.createOverlay(this.getView(), textHolder);
        this.textArea.setBounds(this.getFieldBounds(textHolder), textHolder.getText());
        this.textArea.requestFocus();
        this.typingTarget = textHolder;
    }

    private Rectangle2D.Double getFieldBounds(TextHolder textHolder) {
        Rectangle2D.Double double_ = textHolder.getBounds();
        Insets2DDouble insets2DDouble = textHolder.getInsets();
        double_ = new Rectangle2D.Double(double_.x + insets2DDouble.left, double_.y + insets2DDouble.top, double_.width - insets2DDouble.left - insets2DDouble.right, double_.height - insets2DDouble.top - insets2DDouble.bottom);
        double_.x -= 1.0;
        double_.y -= 2.0;
        double_.width += 18.0;
        double_.height += 4.0;
        return double_;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.createdFigure != null) {
            TextHolder textHolder = (TextHolder)this.createdFigure;
            Rectangle2D.Double double_ = this.createdFigure.getBounds();
            if (double_.width == 0.0 && double_.height == 0.0) {
                this.getDrawing().remove(this.createdFigure);
            } else {
                if (double_.width < 5.0 && double_.height < 5.0) {
                    this.createdFigure.willChange();
                    this.createdFigure.basicSetBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + 100.0, double_.y + 100.0));
                    this.createdFigure.changed();
                }
                this.getView().addToSelection(this.createdFigure);
            }
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.createdFigure = null;
            this.getDrawing().fireUndoableEditHappened(this.creationEdit);
            this.beginEdit(textHolder);
        }
    }

    protected void endEdit() {
        if (this.typingTarget != null) {
            if (this.textArea.getText().length() > 0) {
                this.typingTarget.setText(this.textArea.getText());
                if (this.createdFigure != null) {
                    this.getDrawing().fireUndoableEditHappened(this.creationEdit);
                    this.createdFigure = null;
                }
            } else if (this.createdFigure != null) {
                this.getDrawing().remove(this.getAddedFigure());
            } else {
                this.typingTarget.setText("");
            }
            this.typingTarget = null;
            this.textArea.endOverlay();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.endEdit();
        this.fireToolDone();
    }
}

