/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.FontSizeHandle;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextHolder;
import org.jhotdraw.draw.TextTool;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2DDouble;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFigure
extends AttributedFigure
implements TextHolder {
    protected Point2D.Double origin = new Point2D.Double();
    private boolean editable = true;
    private transient TextLayout textLayout;

    public TextFigure() {
        this("Text");
    }

    public TextFigure(String string) {
        this.setText(string);
    }

    @Override
    public String getText() {
        return (String)this.getAttribute(AttributeKeys.TEXT);
    }

    @Override
    public void setText(String string) {
        this.setAttribute(AttributeKeys.TEXT, string);
    }

    @Override
    public void basicTransform(AffineTransform affineTransform) {
        affineTransform.transform(this.origin, this.origin);
    }

    @Override
    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.origin = new Point2D.Double(double_.x, double_.y);
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        if (this.getBounds().contains(double_)) {
            return true;
        }
        if (this.decorator != null) {
            this.updateDecoratorBounds();
            return this.decorator.contains(double_);
        }
        return false;
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
    }

    @Override
    protected void drawText(Graphics2D graphics2D) {
        if (this.getText() != null || this.isEditable()) {
            TextLayout textLayout = this.getTextLayout();
            textLayout.draw(graphics2D, (float)this.origin.x, (float)(this.origin.y + (double)textLayout.getAscent()));
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.textLayout = null;
    }

    protected TextLayout getTextLayout() {
        if (this.textLayout == null) {
            String string = this.getText();
            if (string == null || string.length() == 0) {
                string = " ";
            }
            FontRenderContext fontRenderContext = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> hashMap = new HashMap<TextAttribute, Serializable>();
            hashMap.put(TextAttribute.FONT, this.getFont());
            if (AttributeKeys.FONT_UNDERLINED.get(this).booleanValue()) {
                hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            }
            this.textLayout = new TextLayout(string, hashMap, fontRenderContext);
        }
        return this.textLayout;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        TextLayout textLayout = this.getTextLayout();
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.origin.x, this.origin.y, textLayout.getAdvance(), textLayout.getAscent() + textLayout.getDescent());
        return double_;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double double_ = this.getBounds();
        return new Dimension2DDouble(double_.width, double_.height);
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        if (this.getText() == null) {
            return this.getBounds();
        }
        TextLayout textLayout = this.getTextLayout();
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.origin.x, this.origin.y, textLayout.getAdvance(), textLayout.getAscent());
        Rectangle2D rectangle2D = textLayout.getBounds();
        if (!rectangle2D.isEmpty() && !Double.isNaN(rectangle2D.getX())) {
            double_.add(new Rectangle2D.Double(rectangle2D.getX() + this.origin.x, rectangle2D.getY() + this.origin.y + (double)textLayout.getAscent(), rectangle2D.getWidth(), rectangle2D.getHeight()));
        }
        Geom.grow(double_, 2.0, 2.0);
        return double_;
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList<Handle> linkedList = new LinkedList<Handle>();
        if (n == 0) {
            linkedList.add(new MoveHandle(this, RelativeLocator.northWest()));
            linkedList.add(new MoveHandle(this, RelativeLocator.northEast()));
            linkedList.add(new MoveHandle(this, RelativeLocator.southEast()));
            linkedList.add(new FontSizeHandle(this));
        }
        return linkedList;
    }

    @Override
    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public int getTextColumns() {
        return this.getText() == null ? 4 : Math.max(this.getText().length(), 4);
    }

    @Override
    public Tool getTool(Point2D.Double double_) {
        return this.isEditable() && this.contains(double_) ? new TextTool(this) : null;
    }

    @Override
    public void read(DOMInput dOMInput) throws IOException {
        this.setBounds(new Point2D.Double(dOMInput.getAttribute("x", 0.0), dOMInput.getAttribute("y", 0.0)), new Point2D.Double(0.0, 0.0));
        this.readAttributes(dOMInput);
    }

    @Override
    public void write(DOMOutput dOMOutput) throws IOException {
        Rectangle2D.Double double_ = this.getBounds();
        dOMOutput.addAttribute("x", double_.x);
        dOMOutput.addAttribute("y", double_.y);
        this.writeAttributes(dOMOutput);
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolder getLabelFor() {
        return this;
    }

    @Override
    public Insets2DDouble getInsets() {
        return new Insets2DDouble(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void restoreTo(Object object) {
        Point2D.Double double_ = (Point2D.Double)object;
        this.origin.x = double_.x;
        this.origin.y = double_.y;
    }

    @Override
    public Object getRestoreData() {
        return this.origin.clone();
    }

    @Override
    public TextFigure clone() {
        TextFigure textFigure = (TextFigure)super.clone();
        textFigure.origin = (Point2D.Double)this.origin.clone();
        textFigure.textLayout = null;
        return textFigure;
    }

    @Override
    public Font getFont() {
        return AttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return AttributeKeys.TEXT_COLOR.get(this);
    }

    @Override
    public Color getFillColor() {
        return AttributeKeys.FILL_COLOR.get(this);
    }

    @Override
    public void setFontSize(float f) {
        AttributeKeys.FONT_SIZE.set(this, new Double(f));
    }

    @Override
    public float getFontSize() {
        return AttributeKeys.FONT_SIZE.get(this).floatValue();
    }
}

