/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.AttributedFigure;
import org.jhotdraw.draw.ChopTriangleConnector;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TriangleRotationHandler;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriangleFigure
extends AttributedFigure {
    private Rectangle2D.Double rectangle;

    public TriangleFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public TriangleFigure(AttributeKeys.Orientation orientation) {
        this(0.0, 0.0, 0.0, 0.0, orientation);
    }

    public TriangleFigure(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, AttributeKeys.Orientation.NORTH);
    }

    public TriangleFigure(double d, double d2, double d3, double d4, AttributeKeys.Orientation orientation) {
        this.rectangle = new Rectangle2D.Double(d, d2, d3, d4);
        AttributeKeys.ORIENTATION.set(this, orientation);
    }

    @Override
    public Connector findConnector(Point2D.Double double_, ConnectionFigure connectionFigure) {
        return new ChopTriangleConnector(this);
    }

    @Override
    public Connector findCompatibleConnector(Connector connector, boolean bl) {
        return new ChopTriangleConnector(this);
    }

    @Override
    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        return double_;
    }

    @Override
    protected void drawFill(Graphics2D graphics2D) {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        Shape shape = this.getBezierPath();
        double d = AttributeKeys.getPerpendicularFillGrowth(this);
        if (d != 0.0) {
            GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            shape = growStroke.createStrokedShape(shape);
        }
        graphics2D.fill(shape);
    }

    @Override
    protected void drawStroke(Graphics2D graphics2D) {
        Shape shape = this.getBezierPath();
        double d = AttributeKeys.getPerpendicularDrawGrowth(this);
        if (d != 0.0) {
            GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            shape = growStroke.createStrokedShape(shape);
        }
        graphics2D.draw(shape);
    }

    @Override
    public Collection<Handle> createHandles(int n) {
        LinkedList linkedList = (LinkedList)super.createHandles(n);
        if (n == 0) {
            linkedList.add(new TriangleRotationHandler(this));
        }
        return linkedList;
    }

    public BezierPath getBezierPath() {
        Rectangle2D.Double double_ = (Rectangle2D.Double)this.rectangle.clone();
        BezierPath bezierPath = new BezierPath();
        switch (AttributeKeys.ORIENTATION.get(this)) {
            default: {
                bezierPath.moveTo((float)(double_.x + double_.width / 2.0), (float)double_.y);
                bezierPath.lineTo((float)(double_.x + double_.width), (float)(double_.y + double_.height));
                bezierPath.lineTo((float)double_.x, (float)(double_.y + double_.height));
                break;
            }
            case NORTH_EAST: {
                bezierPath.moveTo((float)double_.x, (float)double_.y);
                bezierPath.lineTo((float)(double_.x + double_.width), (float)double_.y);
                bezierPath.lineTo((float)(double_.x + double_.width), (float)(double_.y + double_.height));
                break;
            }
            case EAST: {
                bezierPath.moveTo((float)double_.x, (float)double_.y);
                bezierPath.lineTo((float)(double_.x + double_.width), (float)(double_.y + double_.height / 2.0));
                bezierPath.lineTo((float)double_.x, (float)(double_.y + double_.height));
                break;
            }
            case SOUTH_EAST: {
                bezierPath.moveTo((float)(double_.x + double_.width), (float)double_.y);
                bezierPath.lineTo((float)(double_.x + double_.width), (float)(double_.y + double_.height));
                bezierPath.lineTo((float)double_.x, (float)(double_.y + double_.height));
                break;
            }
            case SOUTH: {
                bezierPath.moveTo((float)(double_.x + double_.width / 2.0), (float)(double_.y + double_.height));
                bezierPath.lineTo((float)double_.x, (float)double_.y);
                bezierPath.lineTo((float)(double_.x + double_.width), (float)double_.y);
                break;
            }
            case SOUTH_WEST: {
                bezierPath.moveTo((float)(double_.x + double_.width), (float)(double_.y + double_.height));
                bezierPath.lineTo((float)double_.x, (float)(double_.y + double_.height));
                bezierPath.lineTo((float)double_.x, (float)double_.y);
                break;
            }
            case WEST: {
                bezierPath.moveTo((float)double_.x, (float)(double_.y + double_.height / 2.0));
                bezierPath.lineTo((float)(double_.x + double_.width), (float)double_.y);
                bezierPath.lineTo((float)(double_.x + double_.width), (float)(double_.y + double_.height));
                break;
            }
            case NORTH_WEST: {
                bezierPath.moveTo((float)double_.x, (float)(double_.y + double_.height));
                bezierPath.lineTo((float)double_.x, (float)double_.y);
                bezierPath.lineTo((float)(double_.x + double_.width), (float)double_.y);
            }
        }
        bezierPath.setClosed(true);
        return bezierPath;
    }

    @Override
    public boolean contains(Point2D.Double double_) {
        Shape shape = this.getBezierPath();
        double d = AttributeKeys.getPerpendicularHitGrowth(this);
        if (d != 0.0) {
            GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            shape = growStroke.createStrokedShape(shape);
        }
        return shape.contains(double_);
    }

    @Override
    public void basicSetBounds(Point2D.Double double_, Point2D.Double double_2) {
        this.rectangle.x = Math.min(double_.x, double_2.x);
        this.rectangle.y = Math.min(double_.y, double_2.y);
        this.rectangle.width = Math.max(0.1, Math.abs(double_2.x - double_.x));
        this.rectangle.height = Math.max(0.1, Math.abs(double_2.y - double_.y));
    }

    @Override
    public Rectangle2D.Double getFigureDrawBounds() {
        double d = AttributeKeys.getStrokeTotalWidth(this);
        double d2 = 0.0;
        if (AttributeKeys.STROKE_COLOR.get(this) != null) {
            switch (AttributeKeys.STROKE_PLACEMENT.get(this)) {
                case INSIDE: {
                    d2 = 0.0;
                    break;
                }
                case OUTSIDE: {
                    if (AttributeKeys.STROKE_JOIN.get(this) == 0) {
                        d2 = d * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this);
                        break;
                    }
                    d2 = d;
                    break;
                }
                case CENTER: {
                    d2 = AttributeKeys.STROKE_JOIN.get(this) == 0 ? d / 2.0 * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this) : d / 2.0;
                }
            }
        }
        Rectangle2D.Double double_ = this.getBounds();
        Geom.grow(double_, d2 += 1.0, d2);
        return double_;
    }

    public Point2D.Double chop(Point2D.Double double_) {
        Shape shape = this.getBezierPath();
        double d = AttributeKeys.getPerpendicularHitGrowth(this);
        if (d != 0.0) {
            GrowStroke growStroke = new GrowStroke((float)d, (float)(AttributeKeys.getStrokeTotalWidth(this) * AttributeKeys.STROKE_MITER_LIMIT_FACTOR.get(this)));
            shape = growStroke.createStrokedShape(shape);
        }
        return Geom.chop(shape, double_);
    }

    @Override
    public void basicTransform(AffineTransform affineTransform) {
        Point2D.Double double_ = this.getStartPoint();
        Point2D.Double double_2 = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)affineTransform.transform(double_, double_), (Point2D.Double)affineTransform.transform(double_2, double_2));
    }

    @Override
    public TriangleFigure clone() {
        TriangleFigure triangleFigure = (TriangleFigure)super.clone();
        triangleFigure.rectangle = (Rectangle2D.Double)this.rectangle.clone();
        return triangleFigure;
    }

    @Override
    public void restoreTo(Object object) {
        Rectangle2D.Double double_ = (Rectangle2D.Double)object;
        this.rectangle.x = double_.x;
        this.rectangle.y = double_.y;
        this.rectangle.width = double_.width;
        this.rectangle.height = double_.height;
    }

    @Override
    public Object getRestoreData() {
        return this.rectangle.clone();
    }
}

