/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeChangeEdit;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TriangleFigure;
import org.jhotdraw.geom.Geom;

public class TriangleRotationHandler
extends AbstractHandle {
    private Rectangle centerBox;
    private AttributeKeys.Orientation oldValue;
    private AttributeKeys.Orientation newValue;

    public TriangleRotationHandler(TriangleFigure triangleFigure) {
        super(triangleFigure);
    }

    public boolean isCombinableWith(Handle handle) {
        return false;
    }

    private Point2D.Double getLocation() {
        Point2D.Double double_;
        Rectangle2D.Double double_2 = this.getOwner().getBounds();
        double d = this.getHandlesize();
        switch (AttributeKeys.ORIENTATION.get(this.getOwner())) {
            default: {
                double_ = new Point2D.Double(double_2.x + double_2.width / 2.0, double_2.y + d);
                break;
            }
            case NORTH_EAST: {
                double_ = new Point2D.Double(double_2.x + double_2.width - d, double_2.y + d);
                break;
            }
            case EAST: {
                double_ = new Point2D.Double(double_2.x + double_2.width - d, double_2.y + double_2.height / 2.0);
                break;
            }
            case SOUTH_EAST: {
                double_ = new Point2D.Double(double_2.x + double_2.width - d, double_2.y + double_2.height - d);
                break;
            }
            case SOUTH: {
                double_ = new Point2D.Double(double_2.x + double_2.width / 2.0, double_2.y + double_2.height - d);
                break;
            }
            case SOUTH_WEST: {
                double_ = new Point2D.Double(double_2.x + d, double_2.y + double_2.height - d);
                break;
            }
            case WEST: {
                double_ = new Point2D.Double(double_2.x + d, double_2.y + double_2.height / 2.0);
                break;
            }
            case NORTH_WEST: {
                double_ = new Point2D.Double(double_2.x + d, double_2.y + d);
            }
        }
        return double_;
    }

    protected Rectangle basicGetBounds() {
        Point point = this.view.drawingToView(this.getLocation());
        Rectangle rectangle = new Rectangle(point);
        rectangle.grow(this.getHandlesize() / 2, this.getHandlesize() / 2);
        return rectangle;
    }

    public void trackStart(Point point, int n) {
        this.oldValue = AttributeKeys.ORIENTATION.get(this.getOwner());
        this.centerBox = this.view.drawingToView(this.getOwner().getBounds());
        this.centerBox.grow(this.centerBox.width / -3, this.centerBox.height / -3);
    }

    public void trackStep(Point point, Point point2, int n) {
        Rectangle rectangle = new Rectangle(point2);
        switch (Geom.outcode(this.centerBox, rectangle)) {
            default: {
                this.newValue = AttributeKeys.Orientation.NORTH;
                break;
            }
            case 6: {
                this.newValue = AttributeKeys.Orientation.NORTH_EAST;
                break;
            }
            case 4: {
                this.newValue = AttributeKeys.Orientation.EAST;
                break;
            }
            case 12: {
                this.newValue = AttributeKeys.Orientation.SOUTH_EAST;
                break;
            }
            case 8: {
                this.newValue = AttributeKeys.Orientation.SOUTH;
                break;
            }
            case 9: {
                this.newValue = AttributeKeys.Orientation.SOUTH_WEST;
                break;
            }
            case 1: {
                this.newValue = AttributeKeys.Orientation.WEST;
                break;
            }
            case 3: {
                this.newValue = AttributeKeys.Orientation.NORTH_WEST;
            }
        }
        this.getOwner().willChange();
        AttributeKeys.ORIENTATION.basicSet(this.getOwner(), this.newValue);
        this.getOwner().changed();
        this.updateBounds();
    }

    public void draw(Graphics2D graphics2D) {
        this.drawDiamond(graphics2D, Color.yellow, Color.black);
    }

    public void trackEnd(Point point, Point point2, int n) {
        if (this.newValue != this.oldValue) {
            this.fireUndoableEditHappened(new AttributeChangeEdit(this.getOwner(), AttributeKeys.ORIENTATION, (Object)this.oldValue, (Object)this.newValue));
        }
    }
}

