/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Locale;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.util.ResourceBundleUtil;

public class ApplyAttributesAction
extends AbstractSelectedAction {
    private ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels", Locale.getDefault());

    public ApplyAttributesAction(DrawingEditor drawingEditor) {
        super(drawingEditor);
        this.labels.configureAction(this, "attributesApply");
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.applyAttributes();
    }

    public void applyAttributes() {
        DrawingEditor drawingEditor = this.getEditor();
        for (Figure figure : this.getView().getSelectedFigures()) {
            drawingEditor.applyDefaultAttributesTo(figure);
        }
    }

    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
        this.setEnabled(this.getView().getSelectionCount() == 1);
    }
}

