/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeAction
extends AbstractSelectedAction {
    protected Map<AttributeKey, Object> attributes;

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object) {
        this(drawingEditor, attributeKey, object, null, null);
    }

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, Icon icon) {
        this(drawingEditor, attributeKey, object, null, icon);
    }

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, String string) {
        this(drawingEditor, attributeKey, object, string, null);
    }

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, String string, Icon icon) {
        this(drawingEditor, attributeKey, object, string, icon, null);
    }

    public AttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Object object, String string, Icon icon, Action action) {
        super(drawingEditor);
        this.attributes = new HashMap<AttributeKey, Object>();
        this.attributes.put(attributeKey, object);
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    public AttributeAction(DrawingEditor drawingEditor, Map<AttributeKey, Object> map, String string, Icon icon) {
        super(drawingEditor);
        this.attributes = map;
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getView() != null && this.getView().getSelectionCount() > 0) {
            CompositeEdit compositeEdit = new CompositeEdit(this.labels.getString("drawAttributeChange"));
            this.fireUndoableEditHappened(compositeEdit);
            this.changeAttributes();
            this.fireUndoableEditHappened(compositeEdit);
        }
    }

    public void changeAttributes() {
        Drawing drawing = this.getDrawing();
        for (Map.Entry<AttributeKey, Object> entry : this.attributes.entrySet()) {
            AttributeKey attributeKey = entry.getKey();
            Object object = entry.getValue();
            for (Figure figure : this.getView().getSelectedFigures()) {
                figure.setAttribute(attributeKey, object);
            }
            this.getEditor().setDefaultAttribute(attributeKey, object);
        }
    }
}

