/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

public class DefaultAttributeAction
extends AbstractSelectedAction {
    private AttributeKey[] keys;

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey) {
        this(drawingEditor, attributeKey, null, null);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey[] attributeKeyArray) {
        this(drawingEditor, attributeKeyArray, null, null);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, Icon icon) {
        this(drawingEditor, attributeKey, null, icon);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, String string) {
        this(drawingEditor, attributeKey, string, null);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey attributeKey, String string, Icon icon) {
        this(drawingEditor, new AttributeKey[]{attributeKey}, string, icon);
    }

    public DefaultAttributeAction(DrawingEditor drawingEditor, AttributeKey[] attributeKeyArray, String string, Icon icon) {
        super(drawingEditor);
        this.keys = attributeKeyArray;
        this.putValue("Name", string);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
        drawingEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(DefaultAttributeAction.this.keys[0])) {
                    DefaultAttributeAction.this.putValue("attribute_" + DefaultAttributeAction.this.keys[0], propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getView() != null && this.getView().getSelectionCount() > 0) {
            CompositeEdit compositeEdit = new CompositeEdit(this.labels.getString("drawAttributeChange"));
            this.fireUndoableEditHappened(compositeEdit);
            this.changeAttribute();
            this.fireUndoableEditHappened(compositeEdit);
        }
    }

    public void changeAttribute() {
        Drawing drawing = this.getDrawing();
        for (Figure figure : this.getView().getSelectedFigures()) {
            for (int i = 0; i < this.keys.length; ++i) {
                figure.setAttribute(this.keys[i], this.getEditor().getDefaultAttribute(this.keys[i]));
            }
        }
    }

    public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
    }
}

