/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.undo.CompositeEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupAction
extends AbstractSelectedAction {
    public static final String ID = "selectionGroup";
    private CompositeFigure prototype;

    public GroupAction(DrawingEditor drawingEditor) {
        this(drawingEditor, new GroupFigure());
    }

    public GroupAction(DrawingEditor drawingEditor, CompositeFigure compositeFigure) {
        super(drawingEditor);
        this.prototype = compositeFigure;
        this.labels.configureAction(this, ID);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.canGroup());
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canGroup() {
        return this.getView().getSelectionCount() > 1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.canGroup()) {
            final DrawingView drawingView = this.getView();
            final LinkedList<Figure> linkedList = new LinkedList<Figure>(drawingView.getSelectedFigures());
            final CompositeFigure compositeFigure = (CompositeFigure)this.prototype.clone();
            CompositeEdit compositeEdit = new CompositeEdit(this.labels.getString(ID)){

                public void redo() throws CannotRedoException {
                    super.redo();
                    GroupAction.this.groupFigures(drawingView, compositeFigure, linkedList);
                }

                public void undo() throws CannotUndoException {
                    GroupAction.this.ungroupFigures(drawingView, compositeFigure);
                    super.undo();
                }

                public boolean addEdit(UndoableEdit undoableEdit) {
                    return super.addEdit(undoableEdit);
                }
            };
            this.fireUndoableEditHappened(compositeEdit);
            this.groupFigures(drawingView, compositeFigure, linkedList);
            this.fireUndoableEditHappened(compositeEdit);
        }
    }

    public Collection<Figure> ungroupFigures(DrawingView drawingView, CompositeFigure compositeFigure) {
        LinkedList<Figure> linkedList = new LinkedList<Figure>(compositeFigure.getChildren());
        drawingView.clearSelection();
        compositeFigure.basicRemoveAllChildren();
        drawingView.getDrawing().basicAddAll(linkedList);
        drawingView.getDrawing().remove(compositeFigure);
        drawingView.addToSelection(linkedList);
        return linkedList;
    }

    public void groupFigures(DrawingView drawingView, CompositeFigure compositeFigure, Collection<Figure> collection) {
        Collection<Figure> collection2 = drawingView.getDrawing().sort(collection);
        drawingView.getDrawing().basicRemoveAll(collection);
        drawingView.clearSelection();
        drawingView.getDrawing().add(compositeFigure);
        compositeFigure.willChange();
        for (Figure figure : collection2) {
            compositeFigure.basicAdd(figure);
        }
        compositeFigure.changed();
        drawingView.addToSelection(compositeFigure);
    }
}

