/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import org.jhotdraw.draw.action.PaletteMenuItemUI;
import org.jhotdraw.draw.action.VerticalGridLayout;

public class JPopupButton
extends JButton {
    private JPopupMenu popupMenu;
    private int columnCount = 1;
    private Action action;
    private Rectangle actionArea;
    private Font itemFont;
    public static final Font ITEM_FONT = new Font("Dialog", 0, 10);

    public JPopupButton() {
        this.initComponents();
        this.setFocusable(false);
        this.itemFont = ITEM_FONT;
    }

    public void setItemFont(Font font) {
        this.itemFont = font;
        if (this.popupMenu != null) {
            this.updateFont(this.popupMenu);
        }
    }

    public void setAction(Action action, Rectangle rectangle) {
        this.action = action;
        this.actionArea = rectangle;
        action.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                    JPopupButton.this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                } else {
                    JPopupButton.this.repaint();
                }
            }
        });
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int n, boolean bl) {
        this.columnCount = n;
        this.getPopupMenu().setLayout(new VerticalGridLayout(0, this.getColumnCount(), bl));
    }

    public void add(Action action) {
        JMenuItem jMenuItem = this.getPopupMenu().add(action);
        if (this.getColumnCount() > 1) {
            jMenuItem.setUI(new PaletteMenuItemUI());
        }
        jMenuItem.setFont(this.itemFont);
    }

    public void add(JMenu jMenu) {
        JMenuItem jMenuItem = this.getPopupMenu().add(jMenu);
        this.updateFont(jMenu);
    }

    private void updateFont(MenuElement menuElement) {
        menuElement.getComponent().setFont(this.itemFont);
        for (MenuElement menuElement2 : menuElement.getSubElements()) {
            this.updateFont(menuElement2);
        }
    }

    public void add(JMenuItem jMenuItem) {
        this.getPopupMenu().add(jMenuItem);
        jMenuItem.setFont(this.itemFont);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setLayout(new VerticalGridLayout(0, this.getColumnCount()));
        }
        return this.popupMenu;
    }

    private void initComponents() {
        FormListener formListener = new FormListener();
        this.addMouseListener(formListener);
    }

    private void performAction(MouseEvent mouseEvent) {
        if (this.actionArea != null && this.actionArea.contains(mouseEvent.getX() - this.getInsets().left, mouseEvent.getY() - this.getInsets().top)) {
            this.action.actionPerformed(new ActionEvent(this, 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
        }
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (!(this.popupMenu == null || this.actionArea != null && this.actionArea.contains(mouseEvent.getX() - this.getInsets().left, mouseEvent.getY() - this.getInsets().top))) {
            int n = 0;
            int n2 = this.getHeight();
            if (this.getParent() instanceof JToolBar) {
                JToolBar jToolBar = (JToolBar)this.getParent();
                if (jToolBar.getOrientation() == 1) {
                    n2 = 0;
                    n = jToolBar.getX() > jToolBar.getParent().getInsets().left ? -this.popupMenu.getPreferredSize().width : this.getWidth();
                } else if (jToolBar.getY() > jToolBar.getParent().getInsets().top) {
                    n2 = -this.popupMenu.getPreferredSize().height;
                }
            }
            this.popupMenu.show(this, n, n2);
        }
    }

    private class FormListener
    implements MouseListener {
        private FormListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == JPopupButton.this) {
                JPopupButton.this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == JPopupButton.this) {
                JPopupButton.this.performAction(mouseEvent);
            }
        }
    }
}

