/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.StyledEditorKit;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.ArrowTip;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DelegationSelectionTool;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.LineDecoration;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;
import org.jhotdraw.draw.action.AlignAction;
import org.jhotdraw.draw.action.ApplyAttributesAction;
import org.jhotdraw.draw.action.AttributeAction;
import org.jhotdraw.draw.action.AttributeToggler;
import org.jhotdraw.draw.action.ColorAttributeIcon;
import org.jhotdraw.draw.action.ColorChooserAction;
import org.jhotdraw.draw.action.ColorIcon;
import org.jhotdraw.draw.action.DefaultAttributeAction;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.JPopupButton;
import org.jhotdraw.draw.action.LineDecorationIcon;
import org.jhotdraw.draw.action.MoveAction;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.draw.action.MoveToFrontAction;
import org.jhotdraw.draw.action.PickAttributesAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.StrokeIcon;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.action.ZoomAction;
import org.jhotdraw.draw.action.ZoomEditorAction;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarButtonFactory {
    public static final Map<String, Color> DEFAULT_COLORS;

    private ToolBarButtonFactory() {
    }

    public static Collection<Action> createDrawingActions(DrawingEditor drawingEditor) {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        linkedList.add(new CutAction());
        linkedList.add(new CopyAction());
        linkedList.add(new PasteAction());
        linkedList.add(new SelectAllAction());
        linkedList.add(new SelectSameAction(drawingEditor));
        return linkedList;
    }

    public static Collection<Action> createSelectionActions(DrawingEditor drawingEditor) {
        LinkedList<Action> linkedList = new LinkedList<Action>();
        linkedList.add(new DuplicateAction());
        linkedList.add(null);
        linkedList.add(new GroupAction(drawingEditor));
        linkedList.add(new UngroupAction(drawingEditor));
        linkedList.add(null);
        linkedList.add(new MoveToFrontAction(drawingEditor));
        linkedList.add(new MoveToBackAction(drawingEditor));
        return linkedList;
    }

    public static void addSelectionToolTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ToolBarButtonFactory.addSelectionToolTo(jToolBar, drawingEditor, ToolBarButtonFactory.createDrawingActions(drawingEditor), ToolBarButtonFactory.createSelectionActions(drawingEditor));
    }

    public static void addSelectionToolTo(JToolBar jToolBar, DrawingEditor drawingEditor, Collection<Action> collection, Collection<Action> collection2) {
        JToggleButton jToggleButton;
        ButtonGroup buttonGroup;
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        if (jToolBar.getClientProperty("toolButtonGroup") instanceof ButtonGroup) {
            buttonGroup = (ButtonGroup)jToolBar.getClientProperty("toolButtonGroup");
        } else {
            buttonGroup = new ButtonGroup();
            jToolBar.putClientProperty("toolButtonGroup", buttonGroup);
        }
        DelegationSelectionTool delegationSelectionTool = new DelegationSelectionTool(collection, collection2);
        drawingEditor.setTool(delegationSelectionTool);
        final JToggleButton jToggleButton2 = jToggleButton = new JToggleButton();
        if (jToolBar.getClientProperty("toolHandler") instanceof ToolListener) {
            ToolListener toolListener = (ToolListener)jToolBar.getClientProperty("toolHandler");
        } else {
            ToolListener toolListener = new ToolListener(){

                public void toolStarted(ToolEvent toolEvent) {
                }

                public void toolDone(ToolEvent toolEvent) {
                    jToggleButton2.setSelected(true);
                }

                public void areaInvalidated(ToolEvent toolEvent) {
                }
            };
            jToolBar.putClientProperty("toolHandler", toolListener);
        }
        resourceBundleUtil.configureToolBarButton(jToggleButton, "selectionTool");
        jToggleButton.setSelected(true);
        jToggleButton.addItemListener(new ToolButtonListener(delegationSelectionTool, drawingEditor));
        jToggleButton.setFocusable(false);
        buttonGroup.add(jToggleButton);
        jToolBar.add(jToggleButton);
    }

    public static void addToolTo(JToolBar jToolBar, DrawingEditor drawingEditor, Tool tool, String string, ResourceBundleUtil resourceBundleUtil) {
        ButtonGroup buttonGroup = (ButtonGroup)jToolBar.getClientProperty("toolButtonGroup");
        ToolListener toolListener = (ToolListener)jToolBar.getClientProperty("toolHandler");
        JToggleButton jToggleButton = new JToggleButton();
        resourceBundleUtil.configureToolBarButton(jToggleButton, string);
        jToggleButton.addItemListener(new ToolButtonListener(tool, drawingEditor));
        jToggleButton.setFocusable(false);
        tool.addToolListener(toolListener);
        buttonGroup.add(jToggleButton);
        jToolBar.add(jToggleButton);
    }

    public static void addZoomButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        jToolBar.add(ToolBarButtonFactory.createZoomButton(drawingEditor));
    }

    public static AbstractButton createZoomButton(final DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        final JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "viewZoom");
        jPopupButton.setFocusable(false);
        if (drawingEditor.getDrawingViews().size() == 0) {
            jPopupButton.setText("100 %");
        } else {
            jPopupButton.setText((int)(drawingEditor.getDrawingViews().iterator().next().getScaleFactor() * 100.0) + " %");
        }
        drawingEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "focusedView") {
                    if (propertyChangeEvent.getNewValue() == null) {
                        jPopupButton.setText("100 %");
                    } else {
                        jPopupButton.setText((int)(drawingEditor.getFocusedView().getScaleFactor() * 100.0) + " %");
                    }
                }
            }
        });
        double[] dArray = new double[]{16.0, 8.0, 5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
        for (int i = 0; i < dArray.length; ++i) {
            jPopupButton.add(new ZoomEditorAction(drawingEditor, dArray[i], (AbstractButton)jPopupButton){

                public void actionPerformed(ActionEvent actionEvent) {
                    super.actionPerformed(actionEvent);
                    jPopupButton.setText((int)(this.editor.getView().getScaleFactor() * 100.0) + " %");
                }
            });
        }
        jPopupButton.setFocusable(false);
        return jPopupButton;
    }

    public static AbstractButton createZoomButton(final DrawingView drawingView) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        final JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "viewZoom");
        jPopupButton.setFocusable(false);
        jPopupButton.setText((int)(drawingView.getScaleFactor() * 100.0) + " %");
        drawingView.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "scaleFactor") {
                    jPopupButton.setText((int)(drawingView.getScaleFactor() * 100.0) + " %");
                }
            }
        });
        double[] dArray = new double[]{5.0, 4.0, 3.0, 2.0, 1.5, 1.25, 1.0, 0.75, 0.5, 0.25, 0.1};
        for (int i = 0; i < dArray.length; ++i) {
            jPopupButton.add(new ZoomAction(drawingView, dArray[i], jPopupButton){

                public void actionPerformed(ActionEvent actionEvent) {
                    super.actionPerformed(actionEvent);
                    jPopupButton.setText((int)(drawingView.getScaleFactor() * 100.0) + " %");
                }
            });
        }
        jPopupButton.setFocusable(false);
        return jPopupButton;
    }

    public static void addAttributesButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JButton jButton = jToolBar.add(new PickAttributesAction(drawingEditor));
        jButton.setFocusable(false);
        jButton = jToolBar.add(new ApplyAttributesAction(drawingEditor));
        jButton.setFocusable(false);
        jToolBar.addSeparator();
        ToolBarButtonFactory.addColorButtonsTo(jToolBar, drawingEditor);
        jToolBar.addSeparator();
        ToolBarButtonFactory.addStrokeButtonsTo(jToolBar, drawingEditor);
        jToolBar.addSeparator();
        ToolBarButtonFactory.addFontButtonsTo(jToolBar, drawingEditor);
    }

    public static void addColorButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        ToolBarButtonFactory.addColorButtonTo(jToolBar, drawingEditor, AttributeKeys.STROKE_COLOR, DEFAULT_COLORS, 8, "attributeStrokeColor", resourceBundleUtil);
        ToolBarButtonFactory.addColorButtonTo(jToolBar, drawingEditor, AttributeKeys.FILL_COLOR, DEFAULT_COLORS, 8, "attributeFillColor", resourceBundleUtil);
        ToolBarButtonFactory.addColorButtonTo(jToolBar, drawingEditor, AttributeKeys.TEXT_COLOR, DEFAULT_COLORS, 8, "attributeTextColor", resourceBundleUtil);
    }

    public static void addColorButtonTo(JToolBar jToolBar, DrawingEditor drawingEditor, AttributeKey attributeKey, Map<String, Color> map, int n, String string, ResourceBundleUtil resourceBundleUtil) {
        final JPopupButton jPopupButton = new JPopupButton();
        jPopupButton.setAction(new DefaultAttributeAction(drawingEditor, attributeKey), new Rectangle(0, 0, 22, 22));
        jPopupButton.setColumnCount(n, false);
        for (Map.Entry<String, Color> entry : map.entrySet()) {
            AttributeAction attributeAction = new AttributeAction(drawingEditor, attributeKey, (Object)entry.getValue(), (Icon)new ColorIcon(entry.getValue()));
            jPopupButton.add(attributeAction);
            attributeAction.putValue("ShortDescription", entry.getKey());
        }
        ImageIcon imageIcon = new ImageIcon(ToolBarButtonFactory.class.getResource("/org/jhotdraw/draw/action/images/showColorChooser.png"));
        jPopupButton.add(new ColorChooserAction(drawingEditor, attributeKey, imageIcon));
        resourceBundleUtil.configureToolBarButton(jPopupButton, string);
        jPopupButton.setIcon(new ColorAttributeIcon(drawingEditor, (AttributeKey<Color>)attributeKey, resourceBundleUtil.getImageIcon(string, ToolBarButtonFactory.class).getImage()));
        jPopupButton.setFocusable(false);
        drawingEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jPopupButton.repaint();
            }
        });
        jToolBar.add(jPopupButton);
    }

    public static void addStrokeButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ToolBarButtonFactory.addStrokeDecorationButtonTo(jToolBar, drawingEditor);
        ToolBarButtonFactory.addStrokeWidthButtonTo(jToolBar, drawingEditor);
        ToolBarButtonFactory.addStrokeDashesButtonTo(jToolBar, drawingEditor);
        ToolBarButtonFactory.addStrokeTypeButtonTo(jToolBar, drawingEditor);
        ToolBarButtonFactory.addStrokePlacementButtonTo(jToolBar, drawingEditor);
    }

    public static void addStrokeWidthButtonTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attributeStrokeWidth");
        jPopupButton.setFocusable(false);
        double[] dArray = new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 7.0, 9.0, 11.0};
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).setMaximumFractionDigits(1);
            ((DecimalFormat)numberFormat).setMinimumFractionDigits(0);
        }
        for (int i = 0; i < dArray.length; ++i) {
            String string = Double.toString(dArray[i]);
            jPopupButton.add(new AttributeAction(drawingEditor, AttributeKeys.STROKE_WIDTH, new Double(dArray[i]), string, new StrokeIcon(new BasicStroke((float)dArray[i], 0, 2))));
        }
        jToolBar.add(jPopupButton);
    }

    public static void addStrokeDecorationButtonTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attributeStrokeDecoration");
        jPopupButton.setFocusable(false);
        jPopupButton.setColumnCount(2, false);
        LineDecoration[] lineDecorationArray = new LineDecoration[]{new ArrowTip(0.35, 12.0, 11.3), new ArrowTip(0.35, 13.0, 7.0), null};
        for (int i = 0; i < lineDecorationArray.length; ++i) {
            jPopupButton.add(new AttributeAction(drawingEditor, AttributeKeys.START_DECORATION, lineDecorationArray[i], null, new LineDecorationIcon(lineDecorationArray[i], true)));
            jPopupButton.add(new AttributeAction(drawingEditor, AttributeKeys.END_DECORATION, lineDecorationArray[i], null, new LineDecorationIcon(lineDecorationArray[i], false)));
        }
        jToolBar.add(jPopupButton);
    }

    public static void addStrokeDashesButtonTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attributeStrokeDashes");
        jPopupButton.setFocusable(false);
        double[][] dArrayArray = new double[][]{null, {4.0, 4.0}, {2.0, 2.0}, {4.0, 2.0}, {2.0, 4.0}, {8.0, 2.0}, {6.0, 2.0, 2.0, 2.0}};
        for (int i = 0; i < dArrayArray.length; ++i) {
            float[] fArray;
            if (dArrayArray[i] == null) {
                fArray = null;
            } else {
                fArray = new float[dArrayArray[i].length];
                for (int j = 0; j < dArrayArray[i].length; ++j) {
                    fArray[j] = (float)dArrayArray[i][j];
                }
            }
            jPopupButton.add(new AttributeAction(drawingEditor, AttributeKeys.STROKE_DASHES, dArrayArray[i], null, new StrokeIcon(new BasicStroke(2.0f, 0, 2, 10.0f, fArray, 0.0f))));
        }
        jToolBar.add(jPopupButton);
    }

    public static void addStrokeTypeButtonTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attributeStrokeType");
        jPopupButton.setFocusable(false);
        jPopupButton.add(new AttributeAction(drawingEditor, AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.BASIC, resourceBundleUtil.getString("attributeStrokeTypeBasic"), new StrokeIcon(new BasicStroke(1.0f, 0, 2))));
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        hashMap.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        hashMap.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 2.0);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokeTypeDouble"), (Icon)new StrokeIcon(new DoubleStroke(2.0f, 1.0f))));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        hashMap.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 3.0);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokeTypeDouble"), (Icon)new StrokeIcon(new DoubleStroke(3.0f, 1.0f))));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_TYPE, (Object)AttributeKeys.StrokeType.DOUBLE);
        hashMap.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 4.0);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokeTypeDouble"), (Icon)new StrokeIcon(new DoubleStroke(4.0f, 1.0f))));
        jToolBar.add(jPopupButton);
    }

    public static void addStrokePlacementButtonTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPopupButton jPopupButton = new JPopupButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attributeStrokePlacement");
        jPopupButton.setFocusable(false);
        HashMap<AttributeKey, Object> hashMap = new HashMap<AttributeKey, Object>();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokePlacementCenter"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokePlacementInside"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.CENTER);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokePlacementOutside"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokePlacementCenterFilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokePlacementInsideFilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.FULL);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokePlacementOutsideFilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.CENTER);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokePlacementCenterUnfilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.INSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokePlacementInsideUnfilled"), null));
        hashMap = new HashMap();
        hashMap.put(AttributeKeys.STROKE_PLACEMENT, (Object)AttributeKeys.StrokePlacement.OUTSIDE);
        hashMap.put(AttributeKeys.FILL_UNDER_STROKE, (Object)AttributeKeys.Underfill.NONE);
        jPopupButton.add(new AttributeAction(drawingEditor, hashMap, resourceBundleUtil.getString("attributeStrokePlacementOutsideUnfilled"), null));
        jToolBar.add(jPopupButton);
    }

    public static void addFontButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        JPopupButton jPopupButton = new JPopupButton();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        resourceBundleUtil.configureToolBarButton(jPopupButton, "attributeFont");
        jPopupButton.setFocusable(false);
        Font[] fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("#GungSeo", "#HeadLineA", "#PCMyungjo", "#PilGi", "Al Bayan", "Apple LiGothic", "Apple LiSung", "AppleMyungjo", "Arial Hebrew", "Ayuthaya", "Baghdad", "BiauKai", "Charcoal CY", "Corsiva Hebrew", "DecoType Naskh", "Devanagari MT", "Fang Song", "GB18030 Bitmap", "Geeza Pro", "Geezah", "Geneva CY", "Gujarati MT", "Gurmukhi MT", "Hei", "Helvetica CY", "Hiragino Kaku Gothic Std", "Hiragino Maru Gothic Pro", "Hiragino Mincho Pro", "Hiragino Kaku Gothic Pro", "InaiMathi", "Kai", "Krungthep", "KufiStandardGK", "LiHei Pro", "LiSong Pro", "Mshtakan", "Monaco CY", "Nadeem", "New Peninim MT", "Osaka", "Plantagenet Cherokee", "Raanana", "STFangsong", "STHeiti", "STKaiti", "STSong", "Sathu", "Silom", "Thonburi", "Times CY", "Arial Unicode MS", "Batang", "Estrangelo Edessa", "Gautami", "Kartika", "Latha", "Lucida Sans Unicode", "Mangal", "Marlett", "MS Mincho", "MS Outlook", "MV Boli", "OCR-B-10 BT", "Raavi", "Shruti", "SimSun", "Sylfaen", "Symbol", "Tunga", "Vrinda", "Wingdings", "Wingdings 2", "Wingdings 3", "ZWAdobeF"));
        LinkedList<Font> linkedList = new LinkedList<Font>();
        for (int i = 0; i < fontArray.length; ++i) {
            if (hashSet.contains(fontArray[i].getFamily())) continue;
            linkedList.add(fontArray[i]);
        }
        fontArray = new Font[linkedList.size()];
        fontArray = linkedList.toArray(fontArray);
        Arrays.sort(fontArray, new Comparator<Font>(){

            @Override
            public int compare(Font font, Font font2) {
                int n = font.getFamily().compareTo(font2.getFamily());
                if (n == 0) {
                    n = font.getFontName().compareTo(font2.getFontName());
                }
                return n;
            }
        });
        LinkedList<Font> linkedList2 = new LinkedList<Font>();
        JMenu jMenu = null;
        for (int i = 0; i < fontArray.length; ++i) {
            if (jMenu != null && !fontArray[i].getFamily().equals(fontArray[i - 1].getFamily())) {
                jMenu = null;
            }
            if (jMenu == null && i < fontArray.length - 2 && fontArray[i].getFamily().equals(fontArray[i + 1].getFamily())) {
                linkedList2.add(fontArray[i]);
                jMenu = new JMenu(fontArray[i].getFamily());
                jPopupButton.add(jMenu);
            }
            AttributeAction attributeAction = new AttributeAction(drawingEditor, AttributeKeys.FONT_FACE, fontArray[i], jMenu == null ? fontArray[i].getFamily() : fontArray[i].getFontName(), null, new StyledEditorKit.FontFamilyAction(fontArray[i].getFontName(), fontArray[i].getFamily()));
            if (jMenu == null) {
                linkedList2.add(fontArray[i]);
                jPopupButton.add(attributeAction);
                continue;
            }
            JMenuItem jMenuItem = jMenu.add(attributeAction);
        }
        jPopupButton.setColumnCount(Math.max(1, linkedList2.size() / 32), true);
        resourceBundleUtil.configureToolBarButton(jButton, "attributeFontBold");
        jButton.setFocusable(false);
        resourceBundleUtil.configureToolBarButton(jButton2, "attributeFontItalic");
        jButton2.setFocusable(false);
        resourceBundleUtil.configureToolBarButton(jButton3, "attributeFontUnderline");
        jButton3.setFocusable(false);
        jButton.addActionListener(new AttributeToggler(drawingEditor, AttributeKeys.FONT_BOLD, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.BoldAction()));
        jButton2.addActionListener(new AttributeToggler(drawingEditor, AttributeKeys.FONT_ITALIC, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.ItalicAction()));
        jButton3.addActionListener(new AttributeToggler(drawingEditor, AttributeKeys.FONT_UNDERLINED, Boolean.TRUE, Boolean.FALSE, new StyledEditorKit.UnderlineAction()));
        jToolBar.add(jPopupButton).setFocusable(false);
        jToolBar.add(jButton).setFocusable(false);
        jToolBar.add(jButton2).setFocusable(false);
        jToolBar.add(jButton3).setFocusable(false);
    }

    public static void addAlignmentButtonsTo(JToolBar jToolBar, DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        jToolBar.add(new AlignAction.West(drawingEditor)).setFocusable(false);
        jToolBar.add(new AlignAction.East(drawingEditor)).setFocusable(false);
        jToolBar.add(new AlignAction.Horizontal(drawingEditor)).setFocusable(false);
        jToolBar.add(new AlignAction.North(drawingEditor)).setFocusable(false);
        jToolBar.add(new AlignAction.South(drawingEditor)).setFocusable(false);
        jToolBar.add(new AlignAction.Vertical(drawingEditor)).setFocusable(false);
        jToolBar.addSeparator();
        jToolBar.add(new MoveAction.West(drawingEditor)).setFocusable(false);
        jToolBar.add(new MoveAction.East(drawingEditor)).setFocusable(false);
        jToolBar.add(new MoveAction.North(drawingEditor)).setFocusable(false);
        jToolBar.add(new MoveAction.South(drawingEditor)).setFocusable(false);
        jToolBar.addSeparator();
        jToolBar.add(new MoveToFrontAction(drawingEditor)).setFocusable(false);
        jToolBar.add(new MoveToBackAction(drawingEditor)).setFocusable(false);
    }

    public static AbstractButton createToggleGridButton(final DrawingEditor drawingEditor) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        final JToggleButton jToggleButton = new JToggleButton();
        resourceBundleUtil.configureToolBarButton(jToggleButton, "alignGrid");
        jToggleButton.setFocusable(false);
        jToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GridConstrainer gridConstrainer = jToggleButton.isSelected() ? new GridConstrainer(10.0, 10.0) : new GridConstrainer(1.0, 1.0);
                for (DrawingView drawingView : drawingEditor.getDrawingViews()) {
                    drawingView.setConstrainer(gridConstrainer);
                    drawingView.getContainer().repaint();
                }
            }
        });
        return jToggleButton;
    }

    public static AbstractButton createToggleGridButton(final DrawingView drawingView) {
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        final JToggleButton jToggleButton = new JToggleButton();
        resourceBundleUtil.configureToolBarButton(jToggleButton, "alignGrid");
        jToggleButton.setFocusable(false);
        jToggleButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                GridConstrainer gridConstrainer = jToggleButton.isSelected() ? new GridConstrainer(10.0, 10.0) : new GridConstrainer(1.0, 1.0);
                drawingView.setConstrainer(gridConstrainer);
                drawingView.getContainer().repaint();
            }
        });
        drawingView.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "gridConstrainer") {
                    Constrainer constrainer = (Constrainer)propertyChangeEvent.getNewValue();
                    jToggleButton.setSelected(constrainer.isVisible());
                }
            }
        });
        return jToggleButton;
    }

    static {
        LinkedHashMap<String, Color> linkedHashMap = new LinkedHashMap<String, Color>();
        linkedHashMap.put("Cayenne", new Color(128, 0, 0));
        linkedHashMap.put("Asparagus", new Color(128, 128, 0));
        linkedHashMap.put("Clover", new Color(0, 128, 0));
        linkedHashMap.put("Teal", new Color(0, 128, 128));
        linkedHashMap.put("Midnight", new Color(0, 0, 128));
        linkedHashMap.put("Plum", new Color(128, 0, 128));
        linkedHashMap.put("Tin", new Color(127, 127, 127));
        linkedHashMap.put("Nickel", new Color(128, 128, 128));
        linkedHashMap.put("Maraschino", new Color(255, 0, 0));
        linkedHashMap.put("Lemon", new Color(255, 255, 0));
        linkedHashMap.put("Spring", new Color(0, 255, 0));
        linkedHashMap.put("Turquoise", new Color(0, 255, 255));
        linkedHashMap.put("Blueberry", new Color(0, 0, 255));
        linkedHashMap.put("Magenta", new Color(255, 0, 255));
        linkedHashMap.put("Steel", new Color(102, 102, 102));
        linkedHashMap.put("Aluminium", new Color(153, 153, 153));
        linkedHashMap.put("Salmon", new Color(255, 102, 102));
        linkedHashMap.put("Banana", new Color(255, 255, 102));
        linkedHashMap.put("Flora", new Color(102, 255, 102));
        linkedHashMap.put("Ice", new Color(102, 255, 255));
        linkedHashMap.put("Orchid", new Color(102, 102, 255));
        linkedHashMap.put("Bubblegum", new Color(255, 102, 255));
        linkedHashMap.put("Iron", new Color(76, 76, 76));
        linkedHashMap.put("Magnesium", new Color(179, 179, 179));
        linkedHashMap.put("Mocha", new Color(128, 64, 0));
        linkedHashMap.put("Fern", new Color(64, 128, 0));
        linkedHashMap.put("Moss", new Color(0, 128, 64));
        linkedHashMap.put("Ocean", new Color(0, 64, 128));
        linkedHashMap.put("Eggplant", new Color(64, 0, 128));
        linkedHashMap.put("Maroon", new Color(128, 0, 64));
        linkedHashMap.put("Tungsten", new Color(51, 51, 51));
        linkedHashMap.put("Silver", new Color(204, 204, 204));
        linkedHashMap.put("Tangerine", new Color(255, 128, 0));
        linkedHashMap.put("Lime", new Color(128, 255, 0));
        linkedHashMap.put("Sea Foam", new Color(0, 255, 128));
        linkedHashMap.put("Aqua", new Color(0, 128, 255));
        linkedHashMap.put("Grape", new Color(128, 0, 255));
        linkedHashMap.put("Strawberry", new Color(255, 0, 128));
        linkedHashMap.put("Lead", new Color(25, 25, 25));
        linkedHashMap.put("Mercury", new Color(230, 230, 230));
        linkedHashMap.put("Cantaloupe", new Color(255, 204, 102));
        linkedHashMap.put("Honeydew", new Color(204, 255, 102));
        linkedHashMap.put("Spindrift", new Color(102, 255, 204));
        linkedHashMap.put("Sky", new Color(102, 204, 255));
        linkedHashMap.put("Lavender", new Color(204, 102, 255));
        linkedHashMap.put("Carnation", new Color(255, 111, 207));
        linkedHashMap.put("Licorice", new Color(0, 0, 0));
        linkedHashMap.put("Snow", new Color(255, 255, 255));
        linkedHashMap.put("Transparent", null);
        DEFAULT_COLORS = Collections.unmodifiableMap(linkedHashMap);
    }

    private static class ToolButtonListener
    implements ItemListener {
        private Tool tool;
        private DrawingEditor editor;

        public ToolButtonListener(Tool tool, DrawingEditor drawingEditor) {
            this.tool = tool;
            this.editor = drawingEditor;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.editor.setTool(this.tool);
            }
        }
    }
}

