/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jhotdraw.geom.BezierPath;

public class Bezier {
    private static final int MAXPOINTS = 1000;

    private Bezier() {
    }

    public static void main(String[] stringArray) {
        Point2D.Double[] doubleArray = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.5), new Point2D.Double(1.1, 1.4), new Point2D.Double(2.1, 1.6), new Point2D.Double(3.2, 1.1), new Point2D.Double(4.0, 0.2), new Point2D.Double(4.0, 0.0)};
        double d = 4.0;
        GeneralPath generalPath = Bezier.fitCurve(doubleArray, d);
        System.out.println(generalPath);
    }

    public static GeneralPath fitCurve(Polygon polygon, double d) {
        Point2D.Double[] doubleArray = new Point2D.Double[polygon.npoints];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = new Point2D.Double(polygon.xpoints[i], polygon.ypoints[i]);
        }
        return Bezier.fitCurve(doubleArray, d);
    }

    public static GeneralPath fitCurve(Point2D.Double[] doubleArray, double d) {
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)doubleArray[0].x, (float)doubleArray[0].y);
        double_ = Bezier.computeLeftTangent(doubleArray, 0);
        double_2 = Bezier.computeRightTangent(doubleArray, doubleArray.length - 1);
        Bezier.fitCubic(doubleArray, 0, doubleArray.length - 1, double_, double_2, d, generalPath);
        return generalPath;
    }

    public static BezierPath fitBezierCurve(BezierPath bezierPath, double d) {
        Point2D.Double[] doubleArray = bezierPath.toPolygonArray();
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        BezierPath bezierPath2 = new BezierPath();
        bezierPath2.add(new BezierPath.Node(doubleArray[0]));
        double_ = Bezier.computeLeftTangent(doubleArray, 0);
        double_2 = Bezier.computeRightTangent(doubleArray, doubleArray.length - 1);
        Bezier.fitCubic(doubleArray, 0, doubleArray.length - 1, double_, double_2, d, bezierPath2);
        bezierPath2.setClosed(bezierPath.isClosed());
        return bezierPath2;
    }

    private static void fitCubic(Point2D.Double[] doubleArray, int n, int n2, Point2D.Double double_, Point2D.Double double_2, double d, GeneralPath generalPath) {
        int[] nArray = new int[1];
        int n3 = 4;
        Point2D.Double double_3 = new Point2D.Double();
        double d2 = d * d;
        int n4 = n2 - n + 1;
        if (n4 == 2) {
            double d3 = Bezier.v2DistanceBetween2Points(doubleArray[n2], doubleArray[n]) / 3.0;
            Point2D.Double[] doubleArray2 = new Point2D.Double[4];
            for (int i = 0; i < doubleArray2.length; ++i) {
                doubleArray2[i] = new Point2D.Double();
            }
            doubleArray2[0] = doubleArray[n];
            doubleArray2[3] = doubleArray[n2];
            Bezier.v2Add(doubleArray2[0], Bezier.v2Scale(double_, d3), doubleArray2[1]);
            Bezier.v2Add(doubleArray2[3], Bezier.v2Scale(double_2, d3), doubleArray2[2]);
            generalPath.curveTo((float)doubleArray2[1].x, (float)doubleArray2[1].y, (float)doubleArray2[2].x, (float)doubleArray2[2].y, (float)doubleArray2[3].x, (float)doubleArray2[3].y);
            return;
        }
        double[] dArray = Bezier.chordLengthParameterize(doubleArray, n, n2);
        Point2D.Double[] doubleArray3 = Bezier.generateBezier(doubleArray, n, n2, dArray, double_, double_2);
        double d4 = Bezier.computeMaxError(doubleArray, n, n2, doubleArray3, dArray, nArray);
        if (d4 < d) {
            generalPath.curveTo((float)doubleArray3[1].x, (float)doubleArray3[1].y, (float)doubleArray3[2].x, (float)doubleArray3[2].y, (float)doubleArray3[3].x, (float)doubleArray3[3].y);
            return;
        }
        if (d4 < d2) {
            for (int i = 0; i < n3; ++i) {
                double[] dArray2 = Bezier.reparameterize(doubleArray, n, n2, dArray, doubleArray3);
                d4 = Bezier.computeMaxError(doubleArray, n, n2, doubleArray3 = Bezier.generateBezier(doubleArray, n, n2, dArray2, double_, double_2), dArray2, nArray);
                if (d4 < d) {
                    generalPath.curveTo((float)doubleArray3[1].x, (float)doubleArray3[1].y, (float)doubleArray3[2].x, (float)doubleArray3[2].y, (float)doubleArray3[3].x, (float)doubleArray3[3].y);
                    return;
                }
                dArray = dArray2;
            }
        }
        double_3 = Bezier.computeCenterTangent(doubleArray, nArray[0]);
        Bezier.fitCubic(doubleArray, n, nArray[0], double_, double_3, d, generalPath);
        Bezier.v2Negate(double_3);
        Bezier.fitCubic(doubleArray, nArray[0], n2, double_3, double_2, d, generalPath);
    }

    private static void fitCubic(Point2D.Double[] doubleArray, int n, int n2, Point2D.Double double_, Point2D.Double double_2, double d, BezierPath bezierPath) {
        int[] nArray = new int[1];
        int n3 = 4;
        Point2D.Double double_3 = new Point2D.Double();
        double d2 = d * d;
        int n4 = n2 - n + 1;
        if (n4 == 2) {
            double d3 = Bezier.v2DistanceBetween2Points(doubleArray[n2], doubleArray[n]) / 3.0;
            Point2D.Double[] doubleArray2 = new Point2D.Double[4];
            for (int i = 0; i < doubleArray2.length; ++i) {
                doubleArray2[i] = new Point2D.Double();
            }
            doubleArray2[0] = doubleArray[n];
            doubleArray2[3] = doubleArray[n2];
            Bezier.v2Add(doubleArray2[0], Bezier.v2Scale(double_, d3), doubleArray2[1]);
            Bezier.v2Add(doubleArray2[3], Bezier.v2Scale(double_2, d3), doubleArray2[2]);
            bezierPath.curveTo(doubleArray2[1].x, doubleArray2[1].y, doubleArray2[2].x, doubleArray2[2].y, doubleArray2[3].x, doubleArray2[3].y);
            return;
        }
        double[] dArray = Bezier.chordLengthParameterize(doubleArray, n, n2);
        Point2D.Double[] doubleArray3 = Bezier.generateBezier(doubleArray, n, n2, dArray, double_, double_2);
        double d4 = Bezier.computeMaxError(doubleArray, n, n2, doubleArray3, dArray, nArray);
        if (d4 < d) {
            bezierPath.curveTo(doubleArray3[1].x, doubleArray3[1].y, doubleArray3[2].x, doubleArray3[2].y, doubleArray3[3].x, doubleArray3[3].y);
            return;
        }
        if (d4 < d2) {
            for (int i = 0; i < n3; ++i) {
                double[] dArray2 = Bezier.reparameterize(doubleArray, n, n2, dArray, doubleArray3);
                d4 = Bezier.computeMaxError(doubleArray, n, n2, doubleArray3 = Bezier.generateBezier(doubleArray, n, n2, dArray2, double_, double_2), dArray2, nArray);
                if (d4 < d) {
                    bezierPath.curveTo(doubleArray3[1].x, doubleArray3[1].y, doubleArray3[2].x, doubleArray3[2].y, doubleArray3[3].x, doubleArray3[3].y);
                    return;
                }
                dArray = dArray2;
            }
        }
        double_3 = Bezier.computeCenterTangent(doubleArray, nArray[0]);
        Bezier.fitCubic(doubleArray, n, nArray[0], double_, double_3, d, bezierPath);
        Bezier.v2Negate(double_3);
        Bezier.fitCubic(doubleArray, nArray[0], n2, double_3, double_2, d, bezierPath);
    }

    private static Point2D.Double[] generateBezier(Point2D.Double[] doubleArray, int n, int n2, double[] dArray, Point2D.Double double_, Point2D.Double double_2) {
        int n3;
        Point2D.Double[][] doubleArray2 = new Point2D.Double[1000][2];
        double[][] dArray2 = new double[2][2];
        double[] dArray3 = new double[2];
        Point2D.Double double_3 = new Point2D.Double();
        Point2D.Double[] doubleArray3 = new Point2D.Double[4];
        for (n3 = 0; n3 < doubleArray3.length; ++n3) {
            doubleArray3[n3] = new Point2D.Double();
        }
        int n4 = n2 - n + 1;
        for (n3 = 0; n3 < n4; ++n3) {
            Point2D.Double double_4 = (Point2D.Double)double_.clone();
            Point2D.Double double_5 = (Point2D.Double)double_2.clone();
            Bezier.v2Scale(double_4, Bezier.b1(dArray[n3]));
            Bezier.v2Scale(double_5, Bezier.b2(dArray[n3]));
            doubleArray2[n3][0] = double_4;
            doubleArray2[n3][1] = double_5;
        }
        dArray2[0][0] = 0.0;
        dArray2[0][1] = 0.0;
        dArray2[1][0] = 0.0;
        dArray2[1][1] = 0.0;
        dArray3[0] = 0.0;
        dArray3[1] = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            double[] dArray4 = dArray2[0];
            dArray4[0] = dArray4[0] + Bezier.v2Dot(doubleArray2[n3][0], doubleArray2[n3][0]);
            double[] dArray5 = dArray2[0];
            dArray5[1] = dArray5[1] + Bezier.v2Dot(doubleArray2[n3][0], doubleArray2[n3][1]);
            dArray2[1][0] = dArray2[0][1];
            double[] dArray6 = dArray2[1];
            dArray6[1] = dArray6[1] + Bezier.v2Dot(doubleArray2[n3][1], doubleArray2[n3][1]);
            double_3 = Bezier.v2SubII(doubleArray[n + n3], Bezier.v2AddII(Bezier.v2ScaleIII(doubleArray[n], Bezier.b0(dArray[n3])), Bezier.v2AddII(Bezier.v2ScaleIII(doubleArray[n], Bezier.b1(dArray[n3])), Bezier.v2AddII(Bezier.v2ScaleIII(doubleArray[n2], Bezier.b2(dArray[n3])), Bezier.v2ScaleIII(doubleArray[n2], Bezier.b3(dArray[n3]))))));
            dArray3[0] = dArray3[0] + Bezier.v2Dot(doubleArray2[n3][0], double_3);
            dArray3[1] = dArray3[1] + Bezier.v2Dot(doubleArray2[n3][1], double_3);
        }
        double d = dArray2[0][0] * dArray2[1][1] - dArray2[1][0] * dArray2[0][1];
        double d2 = dArray2[0][0] * dArray3[1] - dArray2[0][1] * dArray3[0];
        double d3 = dArray3[0] * dArray2[1][1] - dArray3[1] * dArray2[0][1];
        if (d == 0.0) {
            d = dArray2[0][0] * dArray2[1][1] * 1.0E-11;
        }
        double d4 = d3 / d;
        double d5 = d2 / d;
        if (d4 < 1.0E-6 || d5 < 1.0E-6) {
            double d6 = Bezier.v2DistanceBetween2Points(doubleArray[n2], doubleArray[n]) / 3.0;
            doubleArray3[0] = doubleArray[n];
            doubleArray3[3] = doubleArray[n2];
            Bezier.v2Add(doubleArray3[0], Bezier.v2Scale(double_, d6), doubleArray3[1]);
            Bezier.v2Add(doubleArray3[3], Bezier.v2Scale(double_2, d6), doubleArray3[2]);
            return doubleArray3;
        }
        doubleArray3[0] = doubleArray[n];
        doubleArray3[3] = doubleArray[n2];
        Bezier.v2Add(doubleArray3[0], Bezier.v2Scale(double_, d4), doubleArray3[1]);
        Bezier.v2Add(doubleArray3[3], Bezier.v2Scale(double_2, d5), doubleArray3[2]);
        return doubleArray3;
    }

    private static double[] reparameterize(Point2D.Double[] doubleArray, int n, int n2, double[] dArray, Point2D.Double[] doubleArray2) {
        int n3 = n2 - n + 1;
        double[] dArray2 = new double[n3];
        for (int i = n; i <= n2; ++i) {
            dArray2[i - n] = Bezier.newtonRaphsonRootFind(doubleArray2, doubleArray[i], dArray[i - n]);
        }
        return dArray2;
    }

    private static double newtonRaphsonRootFind(Point2D.Double[] doubleArray, Point2D.Double double_, double d) {
        int n;
        Point2D.Double[] doubleArray2 = new Point2D.Double[3];
        Point2D.Double[] doubleArray3 = new Point2D.Double[2];
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        Point2D.Double double_4 = new Point2D.Double();
        double_2 = Bezier.bezierII(3, doubleArray, d);
        for (n = 0; n <= 2; ++n) {
            doubleArray2[n] = new Point2D.Double((doubleArray[n + 1].x - doubleArray[n].x) * 3.0, (doubleArray[n + 1].y - doubleArray[n].y) * 3.0);
        }
        for (n = 0; n <= 1; ++n) {
            doubleArray3[n] = new Point2D.Double((doubleArray2[n + 1].x - doubleArray2[n].x) * 2.0, (doubleArray2[n + 1].y - doubleArray2[n].y) * 2.0);
        }
        double_3 = Bezier.bezierII(2, doubleArray2, d);
        double_4 = Bezier.bezierII(1, doubleArray3, d);
        double d2 = (double_2.x - double_.x) * double_3.x + (double_2.y - double_.y) * double_3.y;
        double d3 = double_3.x * double_3.x + double_3.y * double_3.y + (double_2.x - double_.x) * double_4.x + (double_2.y - double_.y) * double_4.y;
        double d4 = d - d2 / d3;
        return d4;
    }

    private static Point2D.Double bezierII(int n, Point2D.Double[] doubleArray, double d) {
        int n2;
        Point2D.Double[] doubleArray2 = new Point2D.Double[n + 1];
        for (n2 = 0; n2 <= n; ++n2) {
            doubleArray2[n2] = (Point2D.Double)doubleArray[n2].clone();
        }
        for (n2 = 1; n2 <= n; ++n2) {
            for (int i = 0; i <= n - n2; ++i) {
                doubleArray2[i].x = (1.0 - d) * doubleArray2[i].x + d * doubleArray2[i + 1].x;
                doubleArray2[i].y = (1.0 - d) * doubleArray2[i].y + d * doubleArray2[i + 1].y;
            }
        }
        Point2D.Double double_ = doubleArray2[0];
        return double_;
    }

    private static double b0(double d) {
        double d2 = 1.0 - d;
        return d2 * d2 * d2;
    }

    private static double b1(double d) {
        double d2 = 1.0 - d;
        return 3.0 * d * (d2 * d2);
    }

    private static double b2(double d) {
        double d2 = 1.0 - d;
        return 3.0 * d * d * d2;
    }

    private static double b3(double d) {
        return d * d * d;
    }

    private static Point2D.Double computeLeftTangent(Point2D.Double[] doubleArray, int n) {
        Point2D.Double double_ = new Point2D.Double();
        double_ = Bezier.v2SubII(doubleArray[n + 1], doubleArray[n]);
        double_ = Bezier.v2Normalize(double_);
        return double_;
    }

    private static Point2D.Double computeRightTangent(Point2D.Double[] doubleArray, int n) {
        Point2D.Double double_ = new Point2D.Double();
        double_ = Bezier.v2SubII(doubleArray[n - 1], doubleArray[n]);
        double_ = Bezier.v2Normalize(double_);
        return double_;
    }

    private static Point2D.Double computeCenterTangent(Point2D.Double[] doubleArray, int n) {
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        double_ = Bezier.v2SubII(doubleArray[n - 1], doubleArray[n]);
        double_2 = Bezier.v2SubII(doubleArray[n], doubleArray[n + 1]);
        double_3.x = (double_.x + double_2.x) / 2.0;
        double_3.y = (double_.y + double_2.y) / 2.0;
        double_3 = Bezier.v2Normalize(double_3);
        return double_3;
    }

    private static double[] chordLengthParameterize(Point2D.Double[] doubleArray, int n, int n2) {
        int n3;
        double[] dArray = new double[n2 - n + 1];
        dArray[0] = 0.0;
        for (n3 = n + 1; n3 <= n2; ++n3) {
            dArray[n3 - n] = dArray[n3 - n - 1] + Bezier.v2DistanceBetween2Points(doubleArray[n3], doubleArray[n3 - 1]);
        }
        for (n3 = n + 1; n3 <= n2; ++n3) {
            dArray[n3 - n] = dArray[n3 - n] / dArray[n2 - n];
        }
        return dArray;
    }

    private static double computeMaxError(Point2D.Double[] doubleArray, int n, int n2, Point2D.Double[] doubleArray2, double[] dArray, int[] nArray) {
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        nArray[0] = (n2 - n + 1) / 2;
        double d = 0.0;
        for (int i = n + 1; i < n2; ++i) {
            double_ = Bezier.bezierII(3, doubleArray2, dArray[i - n]);
            double_2 = Bezier.v2SubII(double_, doubleArray[i]);
            double d2 = Bezier.v2SquaredLength(double_2);
            if (!(d2 >= d)) continue;
            d = d2;
            nArray[0] = i;
        }
        return d;
    }

    private static Point2D.Double v2AddII(Point2D.Double double_, Point2D.Double double_2) {
        Point2D.Double double_3 = new Point2D.Double();
        double_3.x = double_.x + double_2.x;
        double_3.y = double_.y + double_2.y;
        return double_3;
    }

    private static Point2D.Double v2ScaleIII(Point2D.Double double_, double d) {
        Point2D.Double double_2 = new Point2D.Double();
        double_2.x = double_.x * d;
        double_2.y = double_.y * d;
        return double_2;
    }

    private static Point2D.Double v2SubII(Point2D.Double double_, Point2D.Double double_2) {
        Point2D.Double double_3 = new Point2D.Double();
        double_3.x = double_.x - double_2.x;
        double_3.y = double_.y - double_2.y;
        return double_3;
    }

    private static double v2DistanceBetween2Points(Point2D.Double double_, Point2D.Double double_2) {
        double d = double_.x - double_2.x;
        double d2 = double_.y - double_2.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    private static Point2D.Double v2Scale(Point2D.Double double_, double d) {
        double d2 = Bezier.v2Length(double_);
        if (d2 != 0.0) {
            double_.x *= d / d2;
            double_.y *= d / d2;
        }
        return double_;
    }

    private static double v2Length(Point2D.Double double_) {
        return Math.sqrt(Bezier.v2SquaredLength(double_));
    }

    private static double v2SquaredLength(Point2D.Double double_) {
        return double_.x * double_.x + double_.y * double_.y;
    }

    private static Point2D.Double v2Add(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        double_3.x = double_.x + double_2.x;
        double_3.y = double_.y + double_2.y;
        return double_3;
    }

    private static Point2D.Double v2Negate(Point2D.Double double_) {
        double_.x = -double_.x;
        double_.y = -double_.y;
        return double_;
    }

    private static double v2Dot(Point2D.Double double_, Point2D.Double double_2) {
        return double_.x * double_2.x + double_.y * double_2.y;
    }

    private static Point2D.Double v2Normalize(Point2D.Double double_) {
        double d = Bezier.v2Length(double_);
        if (d != 0.0) {
            double_.x /= d;
            double_.y /= d;
        }
        return double_;
    }
}

