/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTree2DDouble<T> {
    private HashMap<T, Rectangle2D.Double> outside = new HashMap();
    private QuadNode root;
    private int maxCapacity = 32;
    private int minSize = 32;
    private int maxOutside = 32;

    public QuadTree2DDouble() {
        this.root = new QuadNode(new Rectangle2D.Double(0.0, 0.0, 800.0, 600.0));
    }

    public QuadTree2DDouble(Rectangle2D.Double double_) {
        this.root = new QuadNode(double_);
    }

    public void add(T t, Rectangle2D.Double double_) {
        if (this.root.bounds.contains(double_)) {
            this.root.add(t, (Rectangle2D.Double)double_.clone());
        } else {
            this.outside.put(t, (Rectangle2D.Double)double_.clone());
            if (this.outside.size() > this.maxOutside) {
                this.reorganize();
            }
        }
    }

    public void reorganize() {
        this.root.join();
        this.outside.putAll(this.root.objects);
        this.root.objects.clear();
        Iterator<Map.Entry<T, Rectangle2D.Double>> iterator = this.outside.entrySet().iterator();
        Map.Entry<T, Rectangle2D.Double> entry2 = iterator.next();
        Rectangle2D.Double double_ = (Rectangle2D.Double)entry2.getValue().clone();
        while (iterator.hasNext()) {
            entry2 = iterator.next();
            Rectangle2D.Double double_2 = entry2.getValue();
            double_.add(double_2);
        }
        this.root.bounds = double_;
        for (Map.Entry<T, Rectangle2D.Double> entry2 : this.outside.entrySet()) {
            this.root.add(entry2.getKey(), entry2.getValue());
        }
        this.outside.clear();
    }

    public void remove(T t) {
        this.outside.remove(t);
        this.root.remove(t);
    }

    public Collection<T> findContains(Point2D.Double double_) {
        HashSet<T> hashSet = new HashSet<T>();
        this.root.findContains(double_, hashSet);
        for (Map.Entry<T, Rectangle2D.Double> entry : this.outside.entrySet()) {
            if (!entry.getValue().contains(double_)) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public Collection<T> findIntersects(Rectangle2D rectangle2D) {
        return this.findIntersects(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()));
    }

    public Collection<T> findIntersects(Rectangle2D.Double double_) {
        HashSet<T> hashSet = new HashSet<T>();
        this.root.findIntersects(double_, hashSet);
        for (Map.Entry<T, Rectangle2D.Double> entry : this.outside.entrySet()) {
            if (!entry.getValue().intersects(double_)) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public Collection<T> findInside(Rectangle2D.Double double_) {
        HashSet<T> hashSet = new HashSet<T>();
        this.root.findInside(double_, hashSet);
        for (Map.Entry<T, Rectangle2D.Double> entry : this.outside.entrySet()) {
            if (!double_.contains(entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuadNode {
        private Rectangle2D.Double bounds;
        private HashMap<T, Rectangle2D.Double> objects;
        private QuadNode northEast;
        private QuadNode northWest;
        private QuadNode southEast;
        private QuadNode southWest;

        public QuadNode(Rectangle2D.Double double_) {
            this.bounds = double_;
            this.objects = new HashMap();
        }

        public boolean isLeaf() {
            return this.northEast == null;
        }

        public void remove(T t) {
            if (this.objects.remove(t) == null && !this.isLeaf()) {
                this.northEast.remove(t);
                this.northWest.remove(t);
                this.southEast.remove(t);
                this.southWest.remove(t);
            }
        }

        public void add(T t, Rectangle2D.Double double_) {
            if (this.isLeaf() && this.objects.size() >= QuadTree2DDouble.this.maxCapacity && this.bounds.width > (double)QuadTree2DDouble.this.minSize && this.bounds.height > (double)QuadTree2DDouble.this.minSize) {
                this.split();
            }
            if (this.isLeaf() || double_.contains(this.bounds)) {
                this.objects.put(t, double_);
            } else {
                if (this.northEast.bounds.intersects(double_)) {
                    this.northEast.add(t, double_);
                }
                if (this.northWest.bounds.intersects(double_)) {
                    this.northWest.add(t, double_);
                }
                if (this.southEast.bounds.intersects(double_)) {
                    this.southEast.add(t, double_);
                }
                if (this.southWest.bounds.intersects(double_)) {
                    this.southWest.add(t, double_);
                }
            }
        }

        public void split() {
            if (this.isLeaf()) {
                double d = this.bounds.width / 2.0;
                double d2 = this.bounds.height / 2.0;
                this.northWest = new QuadNode(new Rectangle2D.Double(this.bounds.x, this.bounds.y, d, d2));
                this.northEast = new QuadNode(new Rectangle2D.Double(this.bounds.x + d, this.bounds.y, this.bounds.width - d, d2));
                this.southWest = new QuadNode(new Rectangle2D.Double(this.bounds.x, this.bounds.y + d2, d, this.bounds.height - d2));
                this.southEast = new QuadNode(new Rectangle2D.Double(this.bounds.x + d, this.bounds.y + d2, this.bounds.width - d, this.bounds.height - d2));
                HashMap hashMap = this.objects;
                this.objects = new HashMap();
                for (Map.Entry entry : hashMap.entrySet()) {
                    this.add(entry.getKey(), entry.getValue());
                }
            }
        }

        public void join() {
            if (!this.isLeaf()) {
                this.northWest.join();
                this.northEast.join();
                this.southWest.join();
                this.southEast.join();
                this.objects.putAll(this.northWest.objects);
                this.objects.putAll(this.northEast.objects);
                this.objects.putAll(this.southWest.objects);
                this.objects.putAll(this.southEast.objects);
                this.northWest = null;
                this.northEast = null;
                this.southWest = null;
                this.southEast = null;
            }
        }

        public void findContains(Point2D.Double double_, HashSet<T> hashSet) {
            if (this.bounds.contains(double_)) {
                for (Map.Entry entry : this.objects.entrySet()) {
                    if (!entry.getValue().contains(double_)) continue;
                    hashSet.add(entry.getKey());
                }
                if (!this.isLeaf()) {
                    this.northWest.findContains(double_, hashSet);
                    this.northEast.findContains(double_, hashSet);
                    this.southWest.findContains(double_, hashSet);
                    this.southEast.findContains(double_, hashSet);
                }
            }
        }

        public void findIntersects(Rectangle2D.Double double_, HashSet<T> hashSet) {
            if (this.bounds.intersects(double_)) {
                int n = hashSet.size();
                for (Map.Entry entry : this.objects.entrySet()) {
                    if (!entry.getValue().intersects(double_)) continue;
                    hashSet.add(entry.getKey());
                }
                if (!this.isLeaf()) {
                    this.northWest.findIntersects(double_, hashSet);
                    this.northEast.findIntersects(double_, hashSet);
                    this.southWest.findIntersects(double_, hashSet);
                    this.southEast.findIntersects(double_, hashSet);
                }
            }
        }

        public void findInside(Rectangle2D.Double double_, HashSet<T> hashSet) {
            if (this.bounds.intersects(double_)) {
                for (Map.Entry entry : this.objects.entrySet()) {
                    if (!double_.contains(entry.getValue())) continue;
                    hashSet.add(entry.getKey());
                }
                if (!this.isLeaf()) {
                    this.northWest.findInside(double_, hashSet);
                    this.northEast.findInside(double_, hashSet);
                    this.southWest.findInside(double_, hashSet);
                    this.southEast.findInside(double_, hashSet);
                }
            }
        }
    }
}

