/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.draw;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.geom.Point2D;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.action.SwingWorker;
import org.jhotdraw.samples.draw.DrawFigureFactory;
import org.jhotdraw.samples.draw.DrawingPanel;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.NanoXMLLiteDOMInput;
import org.jhotdraw.xml.NanoXMLLiteDOMOutput;

public class DrawApplet
extends JApplet {
    private static final String VERSION = "0.5";
    private static final String NAME = "JHotDraw PlasmaDraw";
    private DrawingPanel drawingPanel;
    private ButtonGroup toolButtonGroup;

    public String getParameter(String string) {
        try {
            return super.getParameter(string);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        String[] stringArray = this.getAppletInfo().split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            container.add(new JLabel(stringArray[i].length() == 0 ? " " : stringArray[i]));
        }
        new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                Object object;
                block8: {
                    try {
                        System.out.println("getParameter.datafile:" + DrawApplet.this.getParameter("datafile"));
                        if (DrawApplet.this.getParameter("data") != null) {
                            NanoXMLLiteDOMInput nanoXMLLiteDOMInput = new NanoXMLLiteDOMInput((DOMFactory)new DrawFigureFactory(), new StringReader(DrawApplet.this.getParameter("data")));
                            nanoXMLLiteDOMInput.openElement("PlasmaDraw");
                            object = nanoXMLLiteDOMInput.readObject(0);
                            break block8;
                        }
                        if (DrawApplet.this.getParameter("datafile") != null) {
                            InputStream inputStream = null;
                            try {
                                URL uRL = new URL(DrawApplet.this.getDocumentBase(), DrawApplet.this.getParameter("datafile"));
                                inputStream = uRL.openConnection().getInputStream();
                                NanoXMLLiteDOMInput nanoXMLLiteDOMInput = new NanoXMLLiteDOMInput((DOMFactory)new DrawFigureFactory(), inputStream);
                                nanoXMLLiteDOMInput.openElement("PlasmaDraw");
                                object = nanoXMLLiteDOMInput.readObject(0);
                                break block8;
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                        }
                        object = null;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                    }
                }
                return object;
            }

            public void finished() {
                if (this.getValue() instanceof Throwable) {
                    ((Throwable)this.getValue()).printStackTrace();
                }
                Container container = DrawApplet.this.getContentPane();
                container.setLayout(new BorderLayout());
                container.removeAll();
                container.add(DrawApplet.this.drawingPanel = new DrawingPanel());
                Object object = this.getValue();
                DrawApplet.this.initComponents();
                if (object != null) {
                    if (object instanceof Drawing) {
                        DrawApplet.this.setDrawing((Drawing)object);
                    } else if (object instanceof Throwable) {
                        DrawApplet.this.getDrawing().add(new TextFigure(object.toString()));
                        ((Throwable)object).printStackTrace();
                    }
                }
                container.validate();
            }
        }.start();
    }

    private void setDrawing(Drawing drawing) {
        this.drawingPanel.setDrawing(drawing);
    }

    private Drawing getDrawing() {
        return this.drawingPanel.getDrawing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String string) {
        if (string != null && string.length() > 0) {
            StringReader stringReader = new StringReader(string);
            try {
                NanoXMLLiteDOMInput nanoXMLLiteDOMInput = new NanoXMLLiteDOMInput((DOMFactory)new DrawFigureFactory(), stringReader);
                nanoXMLLiteDOMInput.openElement("PlasmaDraw");
                this.setDrawing((Drawing)nanoXMLLiteDOMInput.readObject(0));
            }
            catch (Throwable throwable) {
                this.getDrawing().clear();
                TextFigure textFigure = new TextFigure();
                textFigure.setText(throwable.getMessage());
                textFigure.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
                this.getDrawing().add(textFigure);
                throwable.printStackTrace();
            }
            finally {
                if (stringReader != null) {
                    stringReader.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        try {
            NanoXMLLiteDOMOutput nanoXMLLiteDOMOutput = new NanoXMLLiteDOMOutput(new DrawFigureFactory());
            nanoXMLLiteDOMOutput.openElement("PlasmaDraw");
            nanoXMLLiteDOMOutput.writeObject(this.getDrawing());
            nanoXMLLiteDOMOutput.closeElement();
            nanoXMLLiteDOMOutput.save(charArrayWriter);
        }
        catch (IOException iOException) {
            TextFigure textFigure = new TextFigure();
            textFigure.setText(iOException.getMessage());
            textFigure.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
            this.getDrawing().add(textFigure);
            iOException.printStackTrace();
        }
        finally {
            if (charArrayWriter != null) {
                charArrayWriter.close();
            }
        }
        return charArrayWriter.toString();
    }

    public String[][] getParameterInfo() {
        return new String[][]{{"data", "String", "the data to be displayed by this applet."}, {"datafile", "URL", "an URL to a file containing the data to be displayed by this applet."}};
    }

    public String getAppletInfo() {
        return "JHotDraw PlasmaDraw\nVersion 0.5\n\nCopyright \u00a9 2004-2006, \u00a9 Werner Randelshofer\nAlle Rights Reserved.\n\nThis software is based on\nJHotDraw \u00a9 1996-1997, IFA Informatik und Erich Gamma\nNanoXML \u00a9 2000-2002 Marc De Scheemaecker\n\nJavaScript code can access the drawing data using the setData() and getData() methods.";
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame jFrame = new JFrame("JHotDraw PlasmaDraw Applet");
                jFrame.setDefaultCloseOperation(3);
                DrawApplet drawApplet = new DrawApplet();
                jFrame.getContentPane().add(drawApplet);
                drawApplet.init();
                jFrame.setSize(500, 400);
                jFrame.setVisible(true);
                drawApplet.start();
            }
        });
    }
}

