/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.draw;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import netscape.javascript.JSObject;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.action.SwingWorker;
import org.jhotdraw.samples.draw.DrawFigureFactory;
import org.jhotdraw.samples.draw.DrawingPanel;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.NanoXMLLiteDOMInput;
import org.jhotdraw.xml.NanoXMLLiteDOMOutput;

public class DrawLiveConnectApplet
extends JApplet {
    private static final String VERSION = "0.44";
    private static final String NAME = "PlasmaDraw";
    private DrawingPanel drawingPanel;
    private JToolBar jToolBar1;
    private JButton loadButton;
    private JButton saveButton;
    private ButtonGroup toolButtonGroup;

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        String[] stringArray = this.getAppletInfo().split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            container.add(new JLabel(stringArray[i]));
        }
        new SwingWorker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                Object object;
                block8: {
                    try {
                        if (DrawLiveConnectApplet.this.getParameter("data") != null && DrawLiveConnectApplet.this.getParameter("data").length() > 0) {
                            NanoXMLLiteDOMInput nanoXMLLiteDOMInput = new NanoXMLLiteDOMInput((DOMFactory)new DrawFigureFactory(), new StringReader(DrawLiveConnectApplet.this.getParameter("data")));
                            nanoXMLLiteDOMInput.openElement(DrawLiveConnectApplet.NAME);
                            object = nanoXMLLiteDOMInput.readObject(0);
                            break block8;
                        }
                        if (DrawLiveConnectApplet.this.getParameter("datafile") != null) {
                            InputStream inputStream = null;
                            try {
                                URL uRL = new URL(DrawLiveConnectApplet.this.getDocumentBase(), DrawLiveConnectApplet.this.getParameter("datafile"));
                                inputStream = uRL.openConnection().getInputStream();
                                NanoXMLLiteDOMInput nanoXMLLiteDOMInput = new NanoXMLLiteDOMInput((DOMFactory)new DrawFigureFactory(), inputStream);
                                nanoXMLLiteDOMInput.openElement(DrawLiveConnectApplet.NAME);
                                object = nanoXMLLiteDOMInput.readObject(0);
                                break block8;
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                        }
                        object = null;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                    }
                }
                return object;
            }

            public void finished() {
                boolean bl;
                Container container = DrawLiveConnectApplet.this.getContentPane();
                container.setLayout(new BorderLayout());
                container.removeAll();
                Object object = this.getValue();
                DrawLiveConnectApplet.this.initComponents();
                if (object != null) {
                    if (object instanceof Drawing) {
                        DrawLiveConnectApplet.this.setDrawing((Drawing)object);
                    } else if (object instanceof Throwable) {
                        DrawLiveConnectApplet.this.getDrawing().add(new TextFigure(object.toString()));
                        ((Throwable)object).printStackTrace();
                    }
                }
                try {
                    Class.forName("netscape.javascript.JSObject");
                    bl = true;
                }
                catch (Throwable throwable) {
                    bl = false;
                }
                DrawLiveConnectApplet.this.loadButton.setEnabled(bl && DrawLiveConnectApplet.this.getParameter("dataread") != null);
                DrawLiveConnectApplet.this.saveButton.setEnabled(bl && DrawLiveConnectApplet.this.getParameter("datawrite") != null);
                if (bl) {
                    JSObject jSObject;
                    Object object2;
                    String string = DrawLiveConnectApplet.this.getParameter("dataread");
                    if (string.indexOf(40) > 0) {
                        string = string.substring(0, string.indexOf(40) - 1);
                    }
                    if ((object2 = (jSObject = JSObject.getWindow((Applet)DrawLiveConnectApplet.this)).call(string, new Object[0])) instanceof String) {
                        DrawLiveConnectApplet.this.setData((String)object2);
                    }
                }
                container.validate();
            }
        }.start();
    }

    private void setDrawing(Drawing drawing) {
        this.drawingPanel.setDrawing(drawing);
    }

    private Drawing getDrawing() {
        return this.drawingPanel.getDrawing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String string) {
        if (string != null && string.length() > 0) {
            StringReader stringReader = new StringReader(string);
            try {
                NanoXMLLiteDOMInput nanoXMLLiteDOMInput = new NanoXMLLiteDOMInput((DOMFactory)new DrawFigureFactory(), stringReader);
                nanoXMLLiteDOMInput.openElement(NAME);
                this.setDrawing((Drawing)nanoXMLLiteDOMInput.readObject(0));
            }
            catch (Throwable throwable) {
                this.getDrawing().clear();
                TextFigure textFigure = new TextFigure();
                textFigure.setText(throwable.getMessage());
                textFigure.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
                this.getDrawing().add(textFigure);
                throwable.printStackTrace();
            }
            finally {
                if (stringReader != null) {
                    stringReader.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        try {
            NanoXMLLiteDOMOutput nanoXMLLiteDOMOutput = new NanoXMLLiteDOMOutput(new DrawFigureFactory());
            nanoXMLLiteDOMOutput.openElement(NAME);
            nanoXMLLiteDOMOutput.writeObject(this.getDrawing());
            nanoXMLLiteDOMOutput.closeElement();
            nanoXMLLiteDOMOutput.save(charArrayWriter);
        }
        catch (IOException iOException) {
            TextFigure textFigure = new TextFigure();
            textFigure.setText(iOException.getMessage());
            textFigure.setBounds(new Point2D.Double(10.0, 10.0), new Point2D.Double(100.0, 100.0));
            this.getDrawing().add(textFigure);
            iOException.printStackTrace();
        }
        finally {
            if (charArrayWriter != null) {
                charArrayWriter.close();
            }
        }
        return charArrayWriter.toString();
    }

    public String[][] getParameterInfo() {
        return new String[][]{{"data", "String", "the data to be displayed by this applet."}, {"datafile", "URL", "an URL to a file containing the data to be displayed by this applet."}, {"dataread", "function()", "the name of a JavaScript function which can be used to read the data."}, {"datawrite", "function()", "the name of a JavaScript function which can be used to write the data."}};
    }

    public String getAppletInfo() {
        return "PlasmaDraw\nVersion 0.44\n\nCopyright 2004 \u00a9 Werner Randelshofer\nAlle Rechte vorbehalten.\n\nDiese Software basiert auf\nJHotDraw \u00a9 1996, 1997 IFA Informatik und Erich Gamma";
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.drawingPanel = new DrawingPanel();
        this.jToolBar1 = new JToolBar();
        this.loadButton = new JButton();
        this.saveButton = new JButton();
        FormListener formListener = new FormListener();
        this.getContentPane().add((Component)this.drawingPanel, "Center");
        this.jToolBar1.setFloatable(false);
        this.loadButton.setText("Laden");
        this.loadButton.addActionListener(formListener);
        this.jToolBar1.add(this.loadButton);
        this.saveButton.setText("Speichern");
        this.saveButton.addActionListener(formListener);
        this.jToolBar1.add(this.saveButton);
        this.getContentPane().add((Component)this.jToolBar1, "South");
    }

    private void save(ActionEvent actionEvent) {
        try {
            String string = this.getParameter("datawrite");
            if (string.indexOf(40) > 0) {
                string = string.substring(0, string.indexOf(40) - 1);
            }
            JSObject jSObject = JSObject.getWindow((Applet)this);
            Object object = jSObject.call(string, this.getData());
        }
        catch (Throwable throwable) {
            TextFigure textFigure = new TextFigure("Fehler: " + throwable);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(10.0, 20.0);
            textFigure.transform(affineTransform);
            this.getDrawing().add(textFigure);
        }
    }

    private void load(ActionEvent actionEvent) {
        try {
            JSObject jSObject;
            Object object;
            String string = this.getParameter("dataread");
            if (string.indexOf(40) > 0) {
                string = string.substring(0, string.indexOf(40) - 1);
            }
            if ((object = (jSObject = JSObject.getWindow((Applet)this)).call(string, new Object[0])) instanceof String) {
                this.setData((String)object);
            }
        }
        catch (Throwable throwable) {
            TextFigure textFigure = new TextFigure("Fehler: " + throwable);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(10.0, 20.0);
            textFigure.transform(affineTransform);
            this.getDrawing().add(textFigure);
        }
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DrawLiveConnectApplet.this.loadButton) {
                DrawLiveConnectApplet.this.load(actionEvent);
            } else if (actionEvent.getSource() == DrawLiveConnectApplet.this.saveButton) {
                DrawLiveConnectApplet.this.save(actionEvent);
            }
        }
    }
}

