/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.common.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.zats.common.json.JSONObject;
import org.zkoss.zats.common.json.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONArray
extends ArrayList<Object>
implements List<Object> {
    private static final long serialVersionUID = 9106884089231309568L;

    public static String toJSONString(List<Object> list) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONArray.writeJSONString(list, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void writeJSONString(List<Object> list, Appendable out) throws IOException {
        if (list == null) {
            out.append("null");
            return;
        }
        boolean first = true;
        out.append('[');
        for (Object value : list) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            if (value == null) {
                out.append("null");
                continue;
            }
            JSONValue.writeJSONString(value, out);
        }
        out.append(']');
    }

    public void merge(Object o2) {
        JSONObject.merge(this, o2);
    }

    public String toJSONString() {
        return JSONArray.toJSONString(this);
    }

    @Override
    public String toString() {
        return this.toJSONString();
    }

    public void writeJSONString(Appendable out) throws IOException {
        JSONArray.writeJSONString(this, out);
    }
}

