/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.common.json;

import java.io.IOException;

class JStylerObj {
    JStylerObj() {
    }

    public static boolean isSpace(char c) {
        return c == '\r' || c == '\n' || c == '\t' || c == ' ';
    }

    public static boolean isSpecialChar(char c) {
        return c == '\b' || c == '\f' || c == '\n';
    }

    public static boolean isSpecialOpen(char c) {
        return c == '{' || c == '[' || c == ',' || c == ':';
    }

    public static boolean isSpecialClose(char c) {
        return c == '}' || c == ']' || c == ',' || c == ':';
    }

    public static boolean isSpecial(char c) {
        return c == '{' || c == '[' || c == ',' || c == '}' || c == ']' || c == ':' || c == '\'' || c == '\"';
    }

    public static boolean isUnicode(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u2000' && c <= '\u20ff';
    }

    public static boolean isKeyword(String s) {
        if (s.length() < 3) {
            return false;
        }
        char c = s.charAt(0);
        if (c == 'n') {
            return s.equals("null");
        }
        if (c == 't') {
            return s.equals("true");
        }
        if (c == 'f') {
            return s.equals("false");
        }
        if (c == 'N') {
            return s.equals("NaN");
        }
        return false;
    }

    public static void escape(String s, Appendable sb) {
        try {
            int i = 0;
            while (i < s.length()) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        break;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '/': {
                        sb.append("\\/");
                        break;
                    }
                    default: {
                        if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                            sb.append("\\u");
                            String hex = "0123456789ABCDEF";
                            sb.append(hex.charAt(ch >> 12 & 0xF));
                            sb.append(hex.charAt(ch >> 8 & 0xF));
                            sb.append(hex.charAt(ch >> 4 & 0xF));
                            sb.append(hex.charAt(ch >> 0 & 0xF));
                            break;
                        }
                        sb.append(ch);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Impossible Error");
        }
    }
}

