/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.common.json.parser;

import java.io.IOException;
import java.io.Reader;
import org.zkoss.zats.common.json.parser.ContainerFactory;
import org.zkoss.zats.common.json.parser.JSONParserStream;
import org.zkoss.zats.common.json.parser.ParseException;

public class JSONParser
extends JSONParserStream {
    protected static boolean[] stopArray = new boolean[126];
    protected static boolean[] stopKey = new boolean[126];
    protected static boolean[] stopValue = new boolean[126];
    protected static boolean[] stopX = new boolean[126];

    static {
        JSONParser.stopKey[58] = true;
        JSONParser.stopValue[125] = true;
        JSONParser.stopValue[44] = true;
        JSONParser.stopArray[93] = true;
        JSONParser.stopArray[44] = true;
    }

    public Object parse(String in) throws IOException, ParseException {
        return this.parse(new FStringReader(in), ContainerFactory.FACTORY);
    }

    public Object parse(String in, ContainerFactory containerFactory) throws ParseException {
        try {
            return this.parse(new FStringReader(in), containerFactory);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class FStringReader
    extends Reader {
        private String str;
        private int length;
        private int next = 0;

        public FStringReader(String s) {
            this.str = s;
            this.length = s.length();
        }

        public int read() throws IOException {
            if (this.next >= this.length) {
                return -1;
            }
            return this.str.charAt(this.next++);
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.next >= this.length) {
                return -1;
            }
            int n = Math.min(this.length - this.next, len);
            this.str.getChars(this.next, this.next + n, cbuf, off);
            this.next += n;
            return n;
        }

        public boolean ready() throws IOException {
            return true;
        }

        public boolean markSupported() {
            return false;
        }

        public void close() {
        }
    }
}

