/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.common.select.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharSequenceIterator
implements Iterator<Character> {
    private CharSequence _sequence;
    private int _begin;
    private int _end;
    private int _curr;
    private char _next;
    private boolean _ready;

    public CharSequenceIterator(CharSequence sequence) {
        this(sequence, 0);
    }

    public CharSequenceIterator(CharSequence sequence, int begin) {
        this(sequence, begin, sequence.length());
    }

    public CharSequenceIterator(CharSequence sequence, int begin, int end) {
        this._sequence = sequence;
        if (begin < 0) {
            throw new IllegalArgumentException("Beginning index cannot be less than 0.");
        }
        this._begin = begin;
        if (end > this._sequence.length()) {
            throw new IllegalArgumentException("End index cannot be greater than sequence length.");
        }
        this._end = end;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this._curr < this._end;
    }

    @Override
    public Character next() {
        return Character.valueOf(this.nextChar());
    }

    public char nextChar() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.seekNext();
        ++this._curr;
        this._ready = false;
        return this._next;
    }

    public int getIndex() {
        return this._curr;
    }

    public void skip() {
        if (this._curr >= this._end) {
            return;
        }
        ++this._curr;
        this._ready = false;
    }

    public void skip(int times) {
        if (this._curr >= this._end) {
            return;
        }
        int i = 0;
        while (this._curr < this._end && i < times) {
            ++this._curr;
            ++i;
        }
        this._ready = false;
    }

    public char peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.seekNext();
        return this._next;
    }

    public char peek(int offset) {
        if (this._curr + offset >= this._end) {
            throw new NoSuchElementException();
        }
        return this._sequence.charAt(this._curr + offset);
    }

    public void reset() {
        this._curr = this._begin;
        this._ready = false;
    }

    private void seekNext() {
        if (this._ready) {
            return;
        }
        this._next = this._sequence.charAt(this._curr);
        this._ready = true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

