/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.common.select.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.zkoss.lang.Strings;
import org.zkoss.zats.common.select.impl.ComponentLocalProperties;
import org.zkoss.zats.common.select.impl.ComponentMatchCtx;
import org.zkoss.zats.common.select.impl.Parser;
import org.zkoss.zats.common.select.impl.PseudoClassDef;
import org.zkoss.zats.common.select.impl.Selector;
import org.zkoss.zats.common.select.impl.SimpleSelectorSequence;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentIterator
implements Iterator<Component> {
    private final Page _page;
    private final Component _root;
    private final List<Selector> _selectorList;
    private final int _posOffset;
    private final boolean _allIds;
    private final Map<String, PseudoClassDef> _localDefs = new HashMap<String, PseudoClassDef>();
    private Component _offsetRoot;
    private ComponentMatchCtx _currCtx;
    private boolean _ready = false;
    private Component _next;
    private int _index = -1;

    public ComponentIterator(Page page, String selector) {
        this(page, null, selector);
    }

    public ComponentIterator(Component root, String selector) {
        this(root.getPage(), root, selector);
    }

    private ComponentIterator(Page page, Component root, String selector) {
        if (page == null && root == null) {
            throw new IllegalArgumentException("Page or root component cannot be null.");
        }
        if (Strings.isEmpty((String)selector)) {
            throw new IllegalArgumentException("Selector string cannot be empty.");
        }
        this._selectorList = new Parser().parse(selector);
        if (this._selectorList.isEmpty()) {
            throw new IllegalStateException("Empty selector");
        }
        this._posOffset = ComponentIterator.getCommonSeqLength(this._selectorList);
        this._allIds = ComponentIterator.isAllIds(this._selectorList, this._posOffset);
        this._root = root;
        this._page = page;
    }

    private static int getCommonSeqLength(List<Selector> list) {
        ArrayList<String> strs = null;
        int max = 0;
        for (Selector selector : list) {
            if (strs == null) {
                strs = new ArrayList<String>();
                for (SimpleSelectorSequence seq : selector) {
                    if (Strings.isEmpty((String)seq.getId())) break;
                    strs.add(seq.toString());
                    strs.add(seq.getCombinator().toString());
                }
                max = strs.size();
                continue;
            }
            int i = 0;
            for (SimpleSelectorSequence seq : selector) {
                if (i >= max || Strings.isEmpty((String)seq.getId()) || !((String)strs.get(i++)).equals(seq.toString()) || !((String)strs.get(i++)).equals(seq.getCombinator().toString())) break;
            }
            if (i-- >= max) continue;
            max = i;
        }
        return (max + 1) / 2;
    }

    private static boolean isAllIds(List<Selector> list, int offset) {
        for (Selector s : list) {
            if (s.size() <= offset) continue;
            return false;
        }
        return true;
    }

    public void setPseudoClassDef(String name, PseudoClassDef def) {
        this._localDefs.put(name, def);
    }

    public PseudoClassDef removePseudoClassDef(String name) {
        return this._localDefs.remove(name);
    }

    public void clearPseudoClassDefs() {
        this._localDefs.clear();
    }

    @Override
    public boolean hasNext() {
        this.loadNext();
        return this._next != null;
    }

    @Override
    public Component next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this._ready = false;
        return this._next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Component peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._next;
    }

    public int nextIndex() {
        return this._ready ? this._index : this._index + 1;
    }

    private void loadNext() {
        if (this._ready) {
            return;
        }
        this._next = this.seekNext();
        this._ready = true;
    }

    private Component seekNext() {
        this._currCtx = this._index < 0 ? this.buildRootCtx() : this.buildNextCtx();
        while (this._currCtx != null && !this._currCtx.isMatched()) {
            this._currCtx = this.buildNextCtx();
        }
        if (this._currCtx != null) {
            ++this._index;
            return this._currCtx.getComponent();
        }
        return null;
    }

    private ComponentMatchCtx buildRootCtx() {
        Component rt;
        Component component = rt = this._root == null ? this._page.getFirstRoot() : this._root;
        if (this._posOffset > 0) {
            Selector selector = this._selectorList.get(0);
            int i = 0;
            while (i < this._posOffset) {
                SimpleSelectorSequence seq = (SimpleSelectorSequence)selector.get(i);
                Component rt2 = rt.getFellowIfAny(seq.getId());
                if (rt2 == null) {
                    return null;
                }
                if (!(ComponentLocalProperties.matchType(rt2, seq.getType()) && ComponentLocalProperties.matchClasses(rt2, seq.getClasses()) && ComponentLocalProperties.matchAttributes(rt2, seq.getAttributes()) && ComponentLocalProperties.matchPseudoClasses(rt2, seq.getPseudoClasses(), this._localDefs))) {
                    return null;
                }
                if (i > 0) {
                    switch (selector.getCombinator(i - 1)) {
                        case DESCENDANT: {
                            if (ComponentIterator.isDescendant(rt2, rt)) break;
                            return null;
                        }
                        case CHILD: {
                            if (rt2.getParent() == rt) break;
                            return null;
                        }
                        case GENERAL_SIBLING: {
                            if (ComponentIterator.isGeneralSibling(rt2, rt)) break;
                            return null;
                        }
                        case ADJACENT_SIBLING: {
                            if (rt2.getPreviousSibling() == rt) break;
                            return null;
                        }
                    }
                }
                rt = rt2;
                ++i;
            }
            this._offsetRoot = rt.getParent();
        }
        ComponentMatchCtx ctx = new ComponentMatchCtx(rt, this._selectorList);
        if (this._posOffset > 0) {
            for (Selector selector : this._selectorList) {
                ctx.setQualified(selector.getSelectorIndex(), this._posOffset - 1);
            }
        } else {
            this.matchLevel0(ctx);
        }
        return ctx;
    }

    /*
     * Unable to fully structure code
     */
    private ComponentMatchCtx buildNextCtx() {
        if (this._allIds) {
            return null;
        }
        if (this._currCtx.getComponent().getFirstChild() == null) ** GOTO lbl8
        return this.buildFirstChildCtx(this._currCtx);
lbl-1000:
        // 1 sources

        {
            this._currCtx = this._currCtx.getParent();
            if (this._currCtx != null && this._currCtx.getComponent() != (this._posOffset > 0 ? this._offsetRoot : this._root)) continue;
            return null;
lbl8:
            // 2 sources

            ** while (this._currCtx.getComponent().getNextSibling() == null)
        }
lbl9:
        // 1 sources

        return this.buildNextSiblingCtx(this._currCtx);
    }

    private ComponentMatchCtx buildFirstChildCtx(ComponentMatchCtx parent) {
        ComponentMatchCtx ctx = new ComponentMatchCtx(parent.getComponent().getFirstChild(), parent);
        if (this._posOffset == 0) {
            this.matchLevel0(ctx);
        }
        for (Selector selector : this._selectorList) {
            int posStart;
            int i = selector.getSelectorIndex();
            int j = posStart = this._posOffset > 0 ? this._posOffset - 1 : 0;
            while (j < selector.size() - 1) {
                switch (selector.getCombinator(j)) {
                    case DESCENDANT: {
                        if (parent.isQualified(i, j) && ComponentIterator.checkIdSpace(selector, j + 1, ctx)) {
                            ctx.setQualified(i, j);
                        }
                    }
                    case CHILD: {
                        if (!parent.isQualified(i, j) || !this.match(selector, ctx, j + 1)) break;
                        ctx.setQualified(i, j + 1);
                    }
                }
                ++j;
            }
        }
        return ctx;
    }

    private ComponentMatchCtx buildNextSiblingCtx(ComponentMatchCtx ctx) {
        ctx.moveToNextSibling();
        for (Selector selector : this._selectorList) {
            int i = selector.getSelectorIndex();
            int posEnd = this._posOffset > 0 ? this._posOffset - 1 : 0;
            int len = selector.size();
            ctx.setQualified(i, len - 1, false);
            int j = len - 2;
            while (j >= posEnd) {
                Selector.Combinator cb = selector.getCombinator(j);
                ComponentMatchCtx parent = ctx.getParent();
                switch (cb) {
                    case DESCENDANT: {
                        boolean parentPass = parent != null && parent.isQualified(i, j);
                        ctx.setQualified(i, j, parentPass && ComponentIterator.checkIdSpace(selector, j + 1, ctx));
                        if (!parentPass || !this.match(selector, ctx, j + 1)) break;
                        ctx.setQualified(i, j + 1);
                        break;
                    }
                    case CHILD: {
                        ctx.setQualified(i, j + 1, parent != null && parent.isQualified(i, j) && this.match(selector, ctx, j + 1));
                        break;
                    }
                    case GENERAL_SIBLING: {
                        if (!ctx.isQualified(i, j)) break;
                        ctx.setQualified(i, j + 1, this.match(selector, ctx, j + 1));
                        break;
                    }
                    case ADJACENT_SIBLING: {
                        ctx.setQualified(i, j + 1, ctx.isQualified(i, j) && this.match(selector, ctx, j + 1));
                        ctx.setQualified(i, j, false);
                    }
                }
                --j;
            }
        }
        if (this._posOffset == 0) {
            this.matchLevel0(ctx);
        }
        return ctx;
    }

    private static boolean checkIdSpace(Selector selector, int index, ComponentMatchCtx ctx) {
        return !selector.requiresIdSpace(index) || !(ctx.getComponent() instanceof IdSpace);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isDescendant(Component c1, Component c2) {
        if (c1 != c2) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            if (c1 == c2) {
                return true;
            }
            if (!(c1 instanceof IdSpace)) continue;
            return c1 == c2;
lbl7:
            // 2 sources

            ** while ((c1 = c1.getParent()) != null)
        }
lbl8:
        // 1 sources

        return false;
    }

    private static boolean isGeneralSibling(Component c1, Component c2) {
        while (c1 != null) {
            if (c1 == c2) {
                return true;
            }
            c1 = c1.getPreviousSibling();
        }
        return false;
    }

    private void matchLevel0(ComponentMatchCtx ctx) {
        for (Selector selector : this._selectorList) {
            if (!this.match(selector, ctx, 0)) continue;
            ctx.setQualified(selector.getSelectorIndex(), 0);
        }
    }

    private boolean match(Selector selector, ComponentMatchCtx ctx, int index) {
        return ctx.match((SimpleSelectorSequence)selector.get(index), this._localDefs);
    }
}

