/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.common.select.impl;

import org.zkoss.zats.common.select.impl.Attribute;
import org.zkoss.zats.common.select.impl.ParseException;
import org.zkoss.zats.common.select.impl.Selector;
import org.zkoss.zats.common.select.impl.SimpleSelectorSequence;
import org.zkoss.zats.common.select.impl.Token;
import org.zkoss.zats.common.select.impl.fsm.StateCtx;
import org.zkoss.zats.common.select.impl.fsm.StateMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InSeqMachine
extends StateMachine<SubState, Token.Type, Token> {
    private Selector _selector;
    private String _source;
    private SimpleSelectorSequence _seq;

    InSeqMachine() {
    }

    public InSeqMachine setSource(String source) {
        this._source = source;
        return this;
    }

    public InSeqMachine setSelector(Selector selector) {
        this._selector = selector;
        return this;
    }

    @Override
    protected Token.Type getClass(Token input) {
        return input.getType();
    }

    @Override
    protected SubState getLandingState(Token input, Token.Type inputClass) {
        switch (inputClass) {
            case IDENTIFIER: 
            case UNIVERSAL: {
                return SubState.MAIN;
            }
            case NTN_ID: {
                return SubState.ID_PRE_VALUE;
            }
            case NTN_CLASS: {
                return SubState.CLASS_PRE_VALUE;
            }
            case NTN_PSDOCLS: {
                return SubState.PSDOCLS_PRE_NAME;
            }
            case OPEN_BRACKET: {
                return SubState.ATTR_PRE_NAME;
            }
        }
        return null;
    }

    @Override
    protected void init() {
        this.setState(SubState.PSDOCLS_PRE_PARAM, new StateCtx<SubState, Token.Type, Token>(){

            @Override
            protected void onLeave(Token input, Token.Type inputClass, SubState dest) {
                InSeqMachine.this._seq.attachPseudoClassParameter(input.source(InSeqMachine.this._source));
            }
        });
        this.getState(SubState.MAIN).addRoute(Token.Type.NTN_ID, SubState.ID_PRE_VALUE).addRoute(Token.Type.IDENTIFIER, SubState.MAIN, new StateCtx.TransitionListener<Token, Token.Type>(){

            @Override
            public void onTransit(Token input, Token.Type inputClass) {
                if (InSeqMachine.this._seq.getId() != null) {
                    throw new ParseException("Illegal selector syntax: cannot have more than 1 ID, failed at index " + input.getBeginIndex());
                }
                InSeqMachine.this._seq.setId(input.source(InSeqMachine.this._source));
            }
        });
        this.getState(SubState.MAIN).addRoute(Token.Type.NTN_CLASS, SubState.CLASS_PRE_VALUE).addRoute(Token.Type.IDENTIFIER, SubState.MAIN, new StateCtx.TransitionListener<Token, Token.Type>(){

            @Override
            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.addClass(input.source(InSeqMachine.this._source));
            }
        });
        this.getState(SubState.MAIN).addRoute(Token.Type.NTN_PSDOCLS, SubState.PSDOCLS_PRE_NAME).addRoute(Token.Type.IDENTIFIER, SubState.PSDOCLS_POST_NAME, new StateCtx.TransitionListener<Token, Token.Type>(){

            @Override
            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.addPseudoClass(input.source(InSeqMachine.this._source));
            }
        }).addRoute(Token.Type.OPEN_PAREN, SubState.PSDOCLS_PRE_PARAM).addReturningClasses((Token.Type[])new Token.Type[]{Token.Type.MINOR_WHITESPACE}).addRoute(Token.Type.IDENTIFIER, SubState.PSDOCLS_POST_PARAM).addReturningClasses((Token.Type[])new Token.Type[]{Token.Type.MINOR_WHITESPACE}).addTransition(Token.Type.PARAM_SEPARATOR, SubState.PSDOCLS_PRE_PARAM).addRoute(Token.Type.CLOSE_PAREN, SubState.MAIN);
        this.getState(SubState.PSDOCLS_POST_NAME).addTransition(Token.Type.NTN_ID, SubState.ID_PRE_VALUE).addTransition(Token.Type.NTN_CLASS, SubState.CLASS_PRE_VALUE).addTransition(Token.Type.NTN_PSDOCLS, SubState.PSDOCLS_PRE_NAME).addTransition(Token.Type.OPEN_BRACKET, SubState.ATTR_PRE_NAME);
        this.getState(SubState.MAIN).addRoute(Token.Type.OPEN_BRACKET, SubState.ATTR_PRE_NAME).addRoute(Token.Type.IDENTIFIER, SubState.ATTR_POST_NAME, new StateCtx.TransitionListener<Token, Token.Type>(){

            @Override
            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.addAttribute(input.source(InSeqMachine.this._source));
            }
        }).addRoutes(SubState.ATTR_PRE_VALUE, new StateCtx.TransitionListener<Token, Token.Type>(){

            @Override
            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.attachAttributeOperator(InSeqMachine.this.getOperator(inputClass));
            }
        }, (C[])new Token.Type[]{Token.Type.OP_EQUAL, Token.Type.OP_BEGIN_WITH, Token.Type.OP_END_WITH, Token.Type.OP_CONTAIN}).addRoute(Token.Type.IDENTIFIER, SubState.ATTR_POST_VALUE, new StateCtx.TransitionListener<Token, Token.Type>(){

            @Override
            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.attachAttributeValue(input.source(InSeqMachine.this._source));
            }
        }).addRoute(Token.Type.CLOSE_BRACKET, SubState.MAIN);
        this.getState(SubState.ATTR_PRE_VALUE).addRoute(Token.Type.DOUBLE_QUOTE, SubState.ATTR_PRE_VALUE_INDQT).addRoute(Token.Type.IDENTIFIER, SubState.ATTR_POST_VALUE_INDQT, new StateCtx.TransitionListener<Token, Token.Type>(){

            @Override
            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.attachAttributeValue(input.source(InSeqMachine.this._source), true);
            }
        }).addRoute(Token.Type.DOUBLE_QUOTE, SubState.ATTR_POST_VALUE);
        this.getState(SubState.ATTR_PRE_VALUE).addRoute(Token.Type.SINGLE_QUOTE, SubState.ATTR_PRE_VALUE_INSQT).addRoute(Token.Type.IDENTIFIER, SubState.ATTR_POST_VALUE_INSQT, new StateCtx.TransitionListener<Token, Token.Type>(){

            @Override
            public void onTransit(Token input, Token.Type inputClass) {
                InSeqMachine.this._seq.attachAttributeValue(input.source(InSeqMachine.this._source), true);
            }
        }).addRoute(Token.Type.SINGLE_QUOTE, SubState.ATTR_POST_VALUE);
    }

    @Override
    protected void onStart(Token input, Token.Type inputClass, SubState landing) {
        this._seq = new SimpleSelectorSequence();
        this._selector.add(this._seq);
        if (inputClass == Token.Type.IDENTIFIER) {
            this._seq.setType(input.source(this._source));
        }
    }

    @Override
    protected void onStop(boolean endOfInput) {
        switch ((SubState)((Object)this._current)) {
            case MAIN: 
            case PSDOCLS_POST_NAME: 
            case PSDOCLS_POST_PARAM: 
            case ATTR_POST_VALUE: {
                break;
            }
            default: {
                if (!endOfInput) break;
                throw new ParseException("Illegal selector syntax: unexpected end of selector string.");
            }
        }
    }

    @Override
    protected void onDebug(String message) {
        super.onDebug("\t" + message);
    }

    private Attribute.Operator getOperator(Token.Type inputClass) {
        switch (inputClass) {
            case OP_EQUAL: {
                return Attribute.Operator.EQUAL;
            }
            case OP_BEGIN_WITH: {
                return Attribute.Operator.BEGIN_WITH;
            }
            case OP_END_WITH: {
                return Attribute.Operator.END_WITH;
            }
            case OP_CONTAIN: {
                return Attribute.Operator.CONTAIN;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubState {
        MAIN,
        ID_PRE_VALUE,
        CLASS_PRE_VALUE,
        PSDOCLS_PRE_NAME,
        PSDOCLS_POST_NAME,
        PSDOCLS_PRE_PARAM,
        PSDOCLS_POST_PARAM,
        ATTR_PRE_NAME,
        ATTR_POST_NAME,
        ATTR_PRE_VALUE,
        ATTR_POST_VALUE,
        ATTR_PRE_VALUE_INSQT,
        ATTR_POST_VALUE_INSQT,
        ATTR_PRE_VALUE_INDQT,
        ATTR_POST_VALUE_INDQT;

    }
}

