/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.common.select.impl;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.zats.common.select.impl.InSeqMachine;
import org.zkoss.zats.common.select.impl.ParseException;
import org.zkoss.zats.common.select.impl.Selector;
import org.zkoss.zats.common.select.impl.Token;
import org.zkoss.zats.common.select.impl.Tokenizer;
import org.zkoss.zats.common.select.impl.fsm.MacroStateCtx;
import org.zkoss.zats.common.select.impl.fsm.StateCtx;
import org.zkoss.zats.common.select.impl.fsm.StateMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private String _source;
    private List<Selector> _selectorSet = new ArrayList<Selector>();
    private Selector _selector;
    private InSeqMachine _submachine;
    private StateMachine<State, CharClass, Token> _machine = new StateMachine<State, CharClass, Token>(){

        @Override
        protected void init() {
            this.getState(State.PRE_SELECTOR).addReturningClasses(CharClass.WHITESPACE).addTransition(CharClass.SELECTOR_LITERAL, State.IN_SELECTOR);
            InSeqMachine inSeqMachine = new InSeqMachine();
            Parser.this._submachine = inSeqMachine;
            this.setState(State.IN_SELECTOR, new MacroStateCtx(inSeqMachine)).addReturningClasses(CharClass.SELECTOR_LITERAL).addTransition(CharClass.WHITESPACE, State.PRE_COMBINATOR).addTransition(CharClass.SELECTOR_SEPARATOR, State.PRE_SELECTOR, new StateCtx.TransitionListener<Token, CharClass>(){

                @Override
                public void onTransit(Token input, CharClass inputClass) {
                    this.flushCurrentSelector();
                }
            });
            this.getState(State.PRE_COMBINATOR).addTransition(CharClass.COMBINATOR, State.POST_COMBINATOR, new StateCtx.TransitionListener<Token, CharClass>(){

                @Override
                public void onTransit(Token input, CharClass inputClass) {
                    Parser.this._selector.attachCombinator(Parser.this.getCombinator(input));
                }
            }).addTransition(CharClass.SELECTOR_LITERAL, State.IN_SELECTOR).addTransition(CharClass.SELECTOR_SEPARATOR, State.PRE_SELECTOR, new StateCtx.TransitionListener<Token, CharClass>(){

                @Override
                public void onTransit(Token input, CharClass inputClass) {
                    this.flushCurrentSelector();
                }
            });
            this.getState(State.POST_COMBINATOR).addTransition(CharClass.WHITESPACE, State.PRE_SELECTOR);
        }

        @Override
        protected CharClass getClass(Token input) {
            switch (input.getType()) {
                case WHITESPACE: {
                    return CharClass.WHITESPACE;
                }
                case CBN_CHILD: 
                case CBN_ADJACENT_SIBLING: 
                case CBN_GENERAL_SIBLING: {
                    return CharClass.COMBINATOR;
                }
                case SELECTOR_SEPARATOR: {
                    return CharClass.SELECTOR_SEPARATOR;
                }
            }
            return CharClass.SELECTOR_LITERAL;
        }

        @Override
        protected State getLandingState(Token input, CharClass inputClass) {
            switch (inputClass) {
                case WHITESPACE: {
                    return State.PRE_SELECTOR;
                }
                case SELECTOR_LITERAL: {
                    return State.IN_SELECTOR;
                }
            }
            return null;
        }

        @Override
        protected void onReset() {
            Parser.this._submachine.setSelector(Parser.this._selector);
            Parser.this._submachine.setSource(Parser.this._source);
        }

        @Override
        protected void onStop(boolean endOfInput) {
        }

        private void flushCurrentSelector() {
            List list = Parser.this._selectorSet;
            Selector selector = new Selector(Parser.this._selectorSet.size());
            Parser.this._selector = selector;
            list.add(selector);
            Parser.this._submachine.setSelector(Parser.this._selector);
        }
    };

    public List<Selector> parse(String source) {
        try {
            return this.parse(new Tokenizer().tokenize(source), source);
        }
        catch (StateMachine.StateMachineException e) {
            throw new ParseException("Illegal selector string: " + source);
        }
    }

    public List<Selector> parse(List<Token> tokens, String source) {
        this._source = source;
        this._selectorSet.clear();
        this._selector = new Selector(0);
        this._selectorSet.add(this._selector);
        this._machine.start((Token)((Object)tokens.iterator()));
        return this._selectorSet;
    }

    public void setDebugMode(boolean mode) {
        this._machine.setDebugMode(mode);
        this._submachine.setDebugMode(mode);
    }

    private Selector.Combinator getCombinator(Token token) {
        switch (token.getType()) {
            case CBN_CHILD: {
                return Selector.Combinator.CHILD;
            }
            case CBN_ADJACENT_SIBLING: {
                return Selector.Combinator.ADJACENT_SIBLING;
            }
            case CBN_GENERAL_SIBLING: {
                return Selector.Combinator.GENERAL_SIBLING;
            }
        }
        throw new IllegalStateException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CharClass {
        SELECTOR_LITERAL,
        WHITESPACE,
        COMBINATOR,
        SELECTOR_SEPARATOR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        PRE_SELECTOR,
        IN_SELECTOR,
        PRE_COMBINATOR,
        POST_COMBINATOR;

    }
}

