/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.common.select.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.zkoss.zats.common.select.impl.Attribute;
import org.zkoss.zats.common.select.impl.PseudoClass;
import org.zkoss.zats.common.select.impl.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSelectorSequence {
    private Selector.Combinator _combinator = Selector.Combinator.DESCENDANT;
    private String _type;
    private String _id;
    private Set<String> _classes = new HashSet<String>();
    private List<Attribute> _attributes = new ArrayList<Attribute>();
    private List<PseudoClass> _pseudoClasses = new ArrayList<PseudoClass>();
    private Attribute _currAttribute;
    private PseudoClass _currPseudoClass;

    public SimpleSelectorSequence() {
    }

    public SimpleSelectorSequence(String type) {
        this();
        this._type = type;
    }

    public Selector.Combinator getCombinator() {
        return this._combinator;
    }

    public String getType() {
        return this._type;
    }

    public String getId() {
        return this._id;
    }

    public Set<String> getClasses() {
        return Collections.unmodifiableSet(this._classes);
    }

    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this._attributes);
    }

    public List<PseudoClass> getPseudoClasses() {
        return Collections.unmodifiableList(this._pseudoClasses);
    }

    public void setCombinator(Selector.Combinator combinator) {
        this._combinator = combinator;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void addClass(String clazz) {
        if (!this._classes.contains(clazz)) {
            this._classes.add(clazz);
        }
    }

    public void addAttribute(String name) {
        this._currAttribute = new Attribute(name);
        this._attributes.add(this._currAttribute);
    }

    public void attachAttributeOperator(Attribute.Operator operator) {
        if (this._currAttribute == null) {
            throw new IllegalStateException();
        }
        this._currAttribute.setOperator(operator);
    }

    public void attachAttributeValue(String value) {
        this.attachAttributeValue(value, false);
    }

    public void attachAttributeValue(String value, boolean quoted) {
        if (this._currAttribute == null) {
            throw new IllegalStateException();
        }
        this._currAttribute.setValue(value, quoted);
    }

    public void attachAttributeQuote(boolean inQuote) {
        if (this._currAttribute == null) {
            throw new IllegalStateException();
        }
        this._currAttribute.setQuoted(inQuote);
    }

    public void addPseudoClass(String function) {
        this._currPseudoClass = new PseudoClass(function);
        this._pseudoClasses.add(this._currPseudoClass);
    }

    public void attachPseudoClassParameter(String parameter) {
        if (this._currPseudoClass == null) {
            throw new IllegalStateException();
        }
        this._currPseudoClass.addParameter(parameter);
    }

    public String toString() {
        if (this._type == null && this._id == null && this._classes.isEmpty() && this._pseudoClasses.isEmpty() && this._attributes.isEmpty()) {
            return "*";
        }
        StringBuffer sb = new StringBuffer(this._type == null ? "" : this._type.toString());
        if (this._id != null) {
            sb.append('#').append(this._id);
        }
        if (!this._classes.isEmpty()) {
            for (String c : this._classes) {
                sb.append('.').append(c);
            }
        }
        if (!this._pseudoClasses.isEmpty()) {
            for (PseudoClass p : this._pseudoClasses) {
                sb.append(p);
            }
        }
        if (!this._attributes.isEmpty()) {
            for (Attribute a : this._attributes) {
                sb.append(a);
            }
        }
        return sb.toString();
    }
}

