/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zats.common.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MultiPartOutputStream
extends FilterOutputStream {
    private static byte[] __CRLF;
    private static byte[] __DASHDASH;
    private static String __ISO_8859_1;
    public static String MULTIPART_MIXED;
    public static String MULTIPART_X_MIXED_REPLACE;
    private String boundary;
    private byte[] boundaryBytes;
    private boolean inPart = false;

    static {
        __ISO_8859_1 = "ISO-8859-1";
        MULTIPART_MIXED = "multipart/mixed";
        MULTIPART_X_MIXED_REPLACE = "multipart/x-mixed-replace";
        try {
            __CRLF = "\r\n".getBytes(__ISO_8859_1);
            __DASHDASH = "--".getBytes(__ISO_8859_1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public MultiPartOutputStream(OutputStream out, String boundary) throws IOException {
        super(out);
        this.boundary = boundary;
        this.boundaryBytes = boundary.getBytes(__ISO_8859_1);
        this.inPart = false;
    }

    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__DASHDASH);
        this.out.write(__CRLF);
        this.inPart = false;
        super.close();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(__ISO_8859_1));
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(__ISO_8859_1));
        this.out.write(__CRLF);
        int i = 0;
        while (headers != null && i < headers.length) {
            this.out.write(headers[i].getBytes(__ISO_8859_1));
            this.out.write(__CRLF);
            ++i;
        }
        this.out.write(__CRLF);
    }
}

