/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.utils;

import java.net.URL;
import paulscode.sound.CommandObject;
import paulscode.sound.FilenameURL;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.utils.XMLNode;
import paulscode.sound.utils.XMLParser;

public class SoundSystemLoader {
    private static SoundSystemLogger logger;
    private static boolean verbose;

    public static SoundSystem loadXML(URL xmlFile, SoundSystem s) {
        if (xmlFile == null) {
            SoundSystemLoader.errorMessage("Parameter 'xmlFile' null in method 'loadXML'");
            return null;
        }
        XMLNode commands = XMLParser.parseXML(xmlFile);
        if (commands == null) {
            SoundSystemLoader.warningMessage("No commands found in XML file");
            return null;
        }
        Class<?> c = null;
        while (commands != null) {
            String command = commands.name().toUpperCase();
            if (command != null && !command.substring(0, 1).equals("/")) {
                String parameter;
                if (command.equals("ADDLIBRARY")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  addLibrary", 0);
                        SoundSystemLoader.message("Class name:  " + commands.get("CLASSNAME"), 1);
                    }
                    try {
                        c = Class.forName(commands.get("CLASSNAME"));
                        if (verbose) {
                            SoundSystemLoader.message("Command:  SoundSystemConfig.addLibrary( " + commands.get("CLASSNAME") + ".class );", 1);
                        }
                        SoundSystemConfig.addLibrary(c);
                    }
                    catch (ClassNotFoundException cnfe) {
                        SoundSystemLoader.errorMessage("Unable to add library plug-in in method 'loadXML':  Class name '" + commands.get("CLASSNAME") + "' not found.");
                    }
                    catch (SoundSystemException sse) {
                        SoundSystemLoader.printStackTrace((Exception)((Object)sse));
                    }
                } else if (command.equals("SETCODEC")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  setCodec", 0);
                        SoundSystemLoader.message("Extension: " + commands.get("EXTENSION"), 1);
                        SoundSystemLoader.message("Class name: " + commands.get("CLASSNAME"), 1);
                    }
                    try {
                        c = Class.forName(commands.get("CLASSNAME"));
                        if (verbose) {
                            SoundSystemLoader.message("Command:  SoundSystemConfig.setCodec( \"" + commands.get("EXTENSION") + "\", " + commands.get("CLASSNAME") + ".class );", 1);
                        }
                        SoundSystemConfig.setCodec((String)commands.get("EXTENSION"), c);
                    }
                    catch (ClassNotFoundException cnfe) {
                        SoundSystemLoader.errorMessage("Unable to set codec plug-in for extension '" + commands.get("EXTENSION") + "' in method 'loadXML':  Class name '" + commands.get("CLASSNAME") + "' not found.");
                    }
                    catch (SoundSystemException sse) {
                        SoundSystemLoader.printStackTrace((Exception)((Object)sse));
                    }
                } else if (command.equals("CREATE")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  create", 0);
                    }
                    if (s != null) {
                        s.cleanup();
                    }
                    s = null;
                    parameter = commands.get("CLASSNAME");
                    if (parameter != null && !parameter.equals("")) {
                        try {
                            c = Class.forName(parameter);
                            if (verbose) {
                                SoundSystemLoader.message("Command:  s = (SoundSystem) new " + parameter + "();", 1);
                                s = (SoundSystem)c.newInstance();
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                            SoundSystemLoader.printStackTrace(cnfe);
                        }
                        catch (InstantiationException ie) {
                            SoundSystemLoader.printStackTrace(ie);
                        }
                        catch (IllegalAccessException iae) {
                            SoundSystemLoader.printStackTrace(iae);
                        }
                        if (verbose) {
                            SoundSystemLoader.message("Unable to instantiate the Sound System in method 'loadXML'  Returning null.", 1);
                            if (s != null) {
                                s.cleanup();
                            }
                            s = null;
                            return null;
                        }
                    } else {
                        if (verbose) {
                            SoundSystemLoader.message("Command:  s = new SoundSystem();", 1);
                        }
                        s = new SoundSystem();
                    }
                } else if (command.equals("LOADSOUND")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  loadSound", 0);
                        SoundSystemLoader.message("Filename: " + commands.get("FILENAME"), 1);
                    }
                    if (s == null) {
                        SoundSystemLoader.errorMessage("Encountered 'loadSound' command before SoundSystem was instantiated in method 'loadXML'.  returning null.");
                        return null;
                    }
                    if (verbose) {
                        SoundSystemLoader.message("Command:  s.loadSound( \"" + commands.get("FILENAME") + "\" );", 1);
                    }
                    s.loadSound(commands.get("FILENAME"));
                } else if (command.equals("NEWSOURCE")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  newSource", 0);
                    }
                    if (s == null) {
                        SoundSystemLoader.errorMessage("Encountered 'newSource' command before SoundSystem was instantiated in method 'loadXML'.  returning null.");
                        return null;
                    }
                    boolean priority = false;
                    boolean toStream = false;
                    boolean toLoop = false;
                    String sourcename = "";
                    String filename = "";
                    float x = 0.0f;
                    float y = 0.0f;
                    float z = 0.0f;
                    int attModel = SoundSystemConfig.getDefaultAttenuation();
                    float distOrRoll = 0.0f;
                    parameter = commands.get("PRIORITY");
                    if (parameter != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("PRIORITY: " + parameter, 1);
                        }
                        if (parameter.toUpperCase().equals("TRUE")) {
                            priority = true;
                        }
                    }
                    if ((parameter = commands.get("TOSTREAM")) != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("TOSTREAM: " + parameter, 1);
                        }
                        if (parameter.toUpperCase().equals("TRUE")) {
                            toStream = true;
                        }
                    }
                    if ((parameter = commands.get("TOLOOP")) != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("TOLOOP: " + parameter, 1);
                        }
                        if (parameter.toUpperCase().equals("TRUE")) {
                            toLoop = true;
                        }
                    }
                    if ((parameter = commands.get("SOURCENAME")) != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("SOURCENAME: " + parameter, 1);
                        }
                        sourcename = parameter;
                    }
                    if ((parameter = commands.get("FILENAME")) != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("FILENAME: " + parameter, 1);
                        }
                        filename = parameter;
                    }
                    if ((parameter = commands.get("X")) != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("X: " + parameter, 1);
                        }
                        try {
                            x = Float.parseFloat(parameter);
                        }
                        catch (NumberFormatException nfe) {
                            SoundSystemLoader.errorMessage("Error parsing float 'X' from String '" + parameter + "' in " + "method 'loadXML'.  Using x=0");
                            x = 0.0f;
                        }
                    }
                    if ((parameter = commands.get("Y")) != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("Y: " + parameter, 1);
                        }
                        try {
                            y = Float.parseFloat(parameter);
                        }
                        catch (NumberFormatException nfe) {
                            SoundSystemLoader.errorMessage("Error parsing float 'Y' from String '" + parameter + "' in " + "method 'loadXML'.  Using y=0");
                            y = 0.0f;
                        }
                    }
                    if ((parameter = commands.get("Z")) != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("Z: " + parameter, 1);
                        }
                        try {
                            x = Float.parseFloat(parameter);
                        }
                        catch (NumberFormatException nfe) {
                            SoundSystemLoader.errorMessage("Error parsing float 'Z' from String '" + parameter + "' in " + "method 'loadXML'.  Using z=0");
                            z = 0.0f;
                        }
                    }
                    if ((parameter = commands.get("ATTMODEL")) != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("ATTMODEL: " + parameter, 1);
                        }
                        if (parameter.toUpperCase().contains("NONE")) {
                            attModel = 0;
                        } else if (parameter.toUpperCase().contains("LINEAR")) {
                            attModel = 2;
                        } else if (parameter.toUpperCase().contains("ROLLOFF")) {
                            attModel = 1;
                        }
                    }
                    if ((parameter = commands.get("DISTORROLL")) != null && !parameter.equals("")) {
                        if (verbose) {
                            SoundSystemLoader.message("DISTORROLL: " + parameter, 1);
                        }
                        try {
                            distOrRoll = Float.parseFloat(parameter);
                        }
                        catch (NumberFormatException nfe) {
                            SoundSystemLoader.errorMessage("Error parsing float 'DISTORROLL' from String '" + parameter + "' in method " + "'loadXML'.  Using default value.");
                            distOrRoll = 0.0f;
                            if (attModel == 2) {
                                distOrRoll = SoundSystemConfig.getDefaultFadeDistance();
                            } else if (attModel == 1) {
                                distOrRoll = SoundSystemConfig.getDefaultAttenuation();
                            }
                        }
                    } else if (attModel == 2) {
                        distOrRoll = SoundSystemConfig.getDefaultFadeDistance();
                    } else if (attModel == 1) {
                        distOrRoll = SoundSystemConfig.getDefaultAttenuation();
                    }
                    if (sourcename.equals("")) {
                        SoundSystemLoader.errorMessage("Parameter 'SOURCENAME' not specified for 'NEWSOURCE' tag in method 'loadXML.  Unable to create new source.");
                    } else if (filename.equals("")) {
                        SoundSystemLoader.errorMessage("Parameter 'FILENAME' not specified for 'NEWSOURCE' tag in method 'loadXML.  Unable to create new source.");
                    } else {
                        if (verbose) {
                            SoundSystemLoader.message("Command:  s.CommandQueue( new paulscode.sound.CommandObject( paulscode.sound.CommandObject.NEW_SOURCE, " + priority + ", " + toStream + ", " + toLoop + ", \"" + sourcename + "\", " + "new paulscode.sound.FilenameURL( \"" + filename + "\" ), " + x + ", " + y + ", " + z + ", " + attModel + ", " + distOrRoll + " ) );", 1);
                        }
                        s.CommandQueue(new CommandObject(10, priority, toStream, toLoop, sourcename, (Object)new FilenameURL(filename), x, y, z, attModel, distOrRoll));
                        if (verbose) {
                            SoundSystemLoader.message("Command:  s.interruptCommandThread();", 1);
                        }
                        s.interruptCommandThread();
                    }
                } else if (command.length() >= 3 && command.substring(0, 3).equals("!--")) {
                    if (verbose) {
                        SoundSystemLoader.message("SoundSystemLoader.loadXML:  comment", 0);
                        if (commands.contents().length() > 6) {
                            SoundSystemLoader.message(commands.contents().substring(3, commands.contents().length() - 2), 1);
                        }
                    }
                } else if (verbose) {
                    SoundSystemLoader.message("SoundSystemLoader.loadXML:  " + command, 0);
                    SoundSystemLoader.message("Unrecognized tag.", 1);
                } else {
                    SoundSystemLoader.warningMessage("Command '" + command + "' not " + "recognized in method 'loadXML'");
                }
            }
            commands = commands.next();
        }
        return s;
    }

    public static void setVerbose(boolean val) {
        verbose = val;
    }

    protected static void message(String message, int indent) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger((SoundSystemLogger)logger);
        }
        logger.message(message, indent);
    }

    protected static void errorMessage(String message) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger((SoundSystemLogger)logger);
        }
        logger.errorMessage("SoundSystemLoader", message, 0);
    }

    protected static void warningMessage(String message) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger((SoundSystemLogger)logger);
        }
        logger.importantMessage("Warning in class 'SoundSystemLoader': " + message, 0);
    }

    protected static void printStackTrace(Exception e) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger((SoundSystemLogger)logger);
        }
        logger.printStackTrace(e, 1);
    }

    static {
        verbose = false;
    }
}

