/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.utils.XMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNode {
    private static SoundSystemLogger logger;
    private static boolean verbose;
    protected String name = "";
    protected String contents = "";
    protected HashMap<String, String> parameters = null;
    protected XMLNode next = null;

    public XMLNode(String XMLText) {
        int lBracket = XMLText.indexOf("<");
        int rBracket = XMLText.indexOf(">");
        if (lBracket == -1 || rBracket == -1) {
            return;
        }
        if (rBracket <= lBracket) {
            XMLNode.errorMessage("Invalid XML syntax: '>' before '<'");
            return;
        }
        this.parameters = new HashMap();
        this.contents = XMLText.substring(lBracket + 1, rBracket);
        this.processTagContents(this.contents);
        if (verbose) {
            this.displayParameters();
        }
        if (rBracket + 1 >= XMLText.length()) {
            return;
        }
        String XMLRemainder = XMLText.substring(rBracket + 1);
        lBracket = XMLRemainder.indexOf("<");
        if (lBracket == -1) {
            return;
        }
        this.next = new XMLNode(XMLRemainder.substring(lBracket));
    }

    public String name() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String contents() {
        if (this.contents == null) {
            return "";
        }
        return this.contents;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public XMLNode next() {
        return this.next;
    }

    public String get(String parameter) {
        if (this.parameters == null) {
            return "";
        }
        return this.parameters.get(parameter.toUpperCase());
    }

    public HashMap<String, String> parameters() {
        return this.parameters;
    }

    public void displayParameters() {
        System.out.println("Parameters for " + this.name + ":");
        Set<String> keys = this.parameters.keySet();
        Iterator<String> iter = keys.iterator();
        if (!iter.hasNext()) {
            System.out.println("    (none)");
        }
        while (iter.hasNext()) {
            String par = iter.next();
            String val = this.parameters.get(par);
            System.out.println("    " + par + " = " + val);
        }
    }

    protected void processTagContents(String tagContents) {
        String[] splitTag = XMLParser.seperateWords(tagContents);
        if (splitTag.length > 0) {
            String paramText;
            this.name = splitTag[0];
            if (this.name.length() >= 3 && this.name.substring(0, 3).equals("!--")) {
                return;
            }
            int x = 1;
            while (x < splitTag.length && !(paramText = splitTag[x]).equals("/")) {
                if (paramText.contains("=")) {
                    String[] pair = paramText.split("=");
                    if (pair == null || pair.length == 0) {
                        XMLNode.errorMessage("Invalid XML syntax: paramater null");
                        return;
                    }
                    if (pair.length == 1) {
                        if (x + 1 >= splitTag.length) {
                            XMLNode.warningMessage("Value not specified for parameter '" + pair[0] + "'");
                            this.parameters.put(pair[0].toUpperCase(), "");
                            ++x;
                            continue;
                        }
                        this.parameters.put(pair[0].toUpperCase(), splitTag[x + 1]);
                        x += 2;
                        continue;
                    }
                    this.parameters.put(pair[0].toUpperCase(), pair[1]);
                    ++x;
                    continue;
                }
                if (x + 1 >= splitTag.length) {
                    XMLNode.warningMessage("Value not specified for parameter '" + splitTag[x] + "'");
                    this.parameters.put(splitTag[x].toUpperCase(), "");
                    ++x;
                    continue;
                }
                if (splitTag[x + 1].equals("=")) {
                    if (x + 2 >= splitTag.length) {
                        XMLNode.warningMessage("Value not specified for parameter '" + splitTag[x] + "'");
                        this.parameters.put(splitTag[x].toUpperCase(), "");
                        x += 2;
                        continue;
                    }
                    this.parameters.put(splitTag[x].toUpperCase(), splitTag[x + 2]);
                    x += 3;
                    continue;
                }
                if (splitTag[x + 1].contains("=")) {
                    String[] eq = splitTag[x + 1].split("=");
                    if (eq == null || eq.length < 1) {
                        XMLNode.warningMessage("Value not specified for parameter '" + splitTag[x] + "'");
                        this.parameters.put(splitTag[x].toUpperCase(), "");
                        x += 2;
                        continue;
                    }
                    this.parameters.put(splitTag[x].toUpperCase(), eq[1]);
                    x += 2;
                    continue;
                }
                XMLNode.warningMessage("Value not specified for parameter '" + splitTag[x] + "'");
                this.parameters.put(splitTag[x].toUpperCase(), "");
                ++x;
            }
        }
    }

    public static void setVerbose(boolean val) {
        verbose = val;
    }

    protected static void errorMessage(String message) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger((SoundSystemLogger)logger);
        }
        logger.errorMessage("XMLNode", message, 0);
    }

    protected static void warningMessage(String message) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger((SoundSystemLogger)logger);
        }
        logger.importantMessage("Warning in class 'XMLNode': " + message, 0);
    }

    static {
        verbose = false;
    }
}

